/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.oneport;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import jeus.util.oneport.OnePortInputStream;

public class OnePortSocket
extends Socket {
    private final Socket src;
    private OnePortInputStream onePortInputStream;
    private InputStream inputStream;
    private final InetAddress localAddress;
    private final int localPort;
    private final InetAddress remoteAddress;
    private final int remotePort;

    public OnePortSocket(Socket src, OnePortInputStream onePortInputStream) {
        this.src = src;
        this.localAddress = src.getLocalAddress();
        this.localPort = src.getLocalPort();
        this.remoteAddress = src.getInetAddress();
        this.remotePort = src.getPort();
        this.onePortInputStream = onePortInputStream;
    }

    public Socket getSocket() {
        return this.src;
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.src.connect(endpoint);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.src.connect(endpoint, timeout);
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.src.bind(bindpoint);
    }

    public InetAddress getInetAddress() {
        return this.remoteAddress;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public SocketAddress getRemoteSocketAddress() {
        return new InetSocketAddress(this.remoteAddress, this.remotePort);
    }

    public SocketAddress getLocalSocketAddress() {
        return new InetSocketAddress(this.localAddress, this.localPort);
    }

    public SocketChannel getChannel() {
        return this.src.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Socket socket = this.src;
        synchronized (socket) {
            if (this.inputStream == null) {
                this.inputStream = new SequenceInputStream(this.onePortInputStream, this.src.getInputStream());
            }
        }
        return this.inputStream;
    }

    public DataInput getDataInput() throws IOException {
        return new DataInputStream(this.getInputStream());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.src.getOutputStream();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.src.setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.src.getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.src.setSoLinger(on, linger);
    }

    public int getSoLinger() throws SocketException {
        return this.src.getSoLinger();
    }

    public void sendUrgentData(int data) throws IOException {
        this.src.sendUrgentData(data);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.src.setOOBInline(on);
    }

    public boolean getOOBInline() throws SocketException {
        return this.src.getOOBInline();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.src.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.src.getSoTimeout();
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.src.setSendBufferSize(size);
    }

    public int getSendBufferSize() throws SocketException {
        return this.src.getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.src.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.src.getReceiveBufferSize();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.src.setKeepAlive(on);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.src.getKeepAlive();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.src.setTrafficClass(tc);
    }

    public int getTrafficClass() throws SocketException {
        return this.src.getTrafficClass();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.src.setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.src.getReuseAddress();
    }

    public void close() throws IOException {
        this.src.close();
    }

    public void shutdownInput() throws IOException {
        this.src.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.src.shutdownOutput();
    }

    public String toString() {
        return this.src.toString();
    }

    public boolean isConnected() {
        return this.src.isConnected();
    }

    public boolean isBound() {
        return this.src.isBound();
    }

    public boolean isClosed() {
        return this.src.isClosed();
    }

    public boolean isInputShutdown() {
        return this.src.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.src.isOutputShutdown();
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.src.setPerformancePreferences(connectionTime, latency, bandwidth);
    }
}

