/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.oneport;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import jeus.io.handler.BlockingStreamHandler;
import jeus.io.handler.StreamHandler;
import jeus.util.logging.JeusLogger;
import jeus.util.oneport.OnePortIOFactory;
import jeus.util.oneport.OnePortInputStream;
import jeus.util.oneport.ProtocolRecognizer;
import jeus.util.oneport.UnrecognizedVirtualPortException;

public class OnePortStreamHandler
extends StreamHandler
implements BlockingStreamHandler,
Runnable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.util.oneport");
    private OnePortInputStream inputStream;
    private volatile boolean closed;
    private ProtocolRecognizer[] recognizers;
    private Executor executor;

    public OnePortStreamHandler(Executor executor, Socket socket, ProtocolRecognizer[] recognizers) throws IOException {
        this.executor = executor;
        this.socket = socket;
        this.recognizers = recognizers;
        this.inputStream = OnePortIOFactory.getInstance().createInputStream(socket);
    }

    public void runThread() {
        this.executor.execute(this);
    }

    public void run() {
        for (int i = 0; i < this.recognizers.length && !this.isClosed(); ++i) {
            ProtocolRecognizer recognizer = this.recognizers[i];
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, recognizer.getProtocol() + " recognizer is trying to recognize new socket[" + this.socket.getInetAddress() + "].");
            }
            try {
                this.inputStream.rewind();
                if (!recognizer.accept(this.inputStream)) continue;
                this.inputStream.stop();
                this.deregister(true);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "New socket[" + this.socket.getInetAddress() + "] is accepted by " + recognizer.getProtocol() + " reconizer.");
                }
                this.socket.setSoTimeout(0);
                recognizer.recognized(OnePortIOFactory.getInstance().createSocket(this.socket, this.inputStream));
                break;
            }
            catch (UnrecognizedVirtualPortException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Unrecognized virutal port [" + e.getVirtualPort() + "].");
                }
                this.close(e);
                continue;
            }
            catch (EOFException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "EOFException occurred while recognizing a socket by " + recognizer.getProtocol() + " reconizer.", (Throwable)e);
                }
                this.close(e);
                continue;
            }
            catch (SocketException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "SocketException occurred while recognizing a socket by " + recognizer.getProtocol() + " reconizer.", (Throwable)e);
                }
                this.close(e);
                continue;
            }
            catch (IOException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "IOException occurred while recognizing a socket by " + recognizer.getProtocol() + " reconizer.", (Throwable)e);
                }
                this.close(e);
                continue;
            }
            catch (Error e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Error occurred while recognizing a socket by " + recognizer.getProtocol() + " reconizer.", (Throwable)e);
                }
                this.close(null);
                continue;
            }
            catch (RuntimeException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "RuntimeException occurred while recognizing a socket by " + recognizer.getProtocol() + " reconizer.", (Throwable)e);
                }
                this.close(e);
            }
        }
    }

    public synchronized void close(Exception ex) {
        if (this.closed) {
            return;
        }
        this.deregister(true);
        try {
            this.socket.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public boolean writeInternal(Object[] buffers) throws IOException {
        throw new UnsupportedOperationException("writeInternal");
    }
}

