/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.oneport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import jeus.util.oneport.OnePortInputStream;

public class SocketChannelOnePortInputStream
extends OnePortInputStream {
    private SocketChannel channel;

    public SocketChannelOnePortInputStream(SocketChannel channel) {
        this(channel, DEFAULT_BUFFER_SIZE);
    }

    public SocketChannelOnePortInputStream(SocketChannel channel, int size) {
        super(size);
        this.channel = channel;
    }

    private SocketChannel getScIfOpen() throws IOException {
        if (this.channel == null) {
            throw new IOException("SocketChannel is closed");
        }
        return this.channel;
    }

    protected int fill0(byte[] buffer, int offset, int length) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, offset, length);
        byteBuffer.position(offset);
        byteBuffer.limit(Math.min(offset + length, byteBuffer.capacity()));
        return this.getScIfOpen().read(byteBuffer);
    }

    protected int available0() throws IOException {
        return 0;
    }

    protected void close0() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }
}

