/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.properties;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import jeus.util.properties.JeusNetProperties;

public class JeusNetPropertyValues {
    public static final String LOCAL_LOOPBACK_ADDRESS;
    public static final String LOCAL_HOSTNAME;
    public static final String LOCAL_FULL_HOSTNAME;
    public static final String LOCAL_HOSTADDRESS;
    public static final InetAddress LOCAL_INETADDRESS;

    private static boolean isAddressMatch(InetAddress inetAddress) {
        boolean result;
        String hostName = inetAddress.getHostName();
        try {
            result = JeusNetProperties.DEFAULT_LOCAL_IP == null || inetAddress.equals(InetAddress.getByName(JeusNetProperties.DEFAULT_LOCAL_IP));
        }
        catch (UnknownHostException e) {
            result = false;
        }
        if (result && JeusNetProperties.DEFAULT_LOCAL_HOSTNAME != null && !JeusNetProperties.DEFAULT_LOCAL_HOSTNAME.equals(hostName)) {
            System.out.println("[WARNING] The local IP is matched to the specified IP, but not for the host name, specified host name : " + JeusNetProperties.DEFAULT_LOCAL_HOSTNAME + ", the host name of the IP : " + hostName);
        }
        return result;
    }

    public static InetAddress getLocalInetAddress() {
        return LOCAL_INETADDRESS;
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (host.equals(LOCAL_FULL_HOSTNAME) || host.equals("localhost")) {
            return LOCAL_INETADDRESS;
        }
        return InetAddress.getByName(host);
    }

    public static boolean isLocalhost(String host) {
        try {
            InetAddress[] localInetAddresses;
            InetAddress inetAddress = InetAddress.getByName(host);
            for (InetAddress address : localInetAddresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
                if (!inetAddress.equals(address)) continue;
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    static {
        String loopback = null;
        try {
            loopback = InetAddress.getByName(null).getHostAddress();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        LOCAL_LOOPBACK_ADDRESS = loopback;
        ArrayList<InetAddress> selectedAddresses = new ArrayList<InetAddress>();
        try {
            InetAddress[] addresses;
            for (InetAddress address : addresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
                if (!JeusNetPropertyValues.isAddressMatch(address)) continue;
                selectedAddresses.add(address);
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.out.println("[NetworkConfiguration] Fail to get local hostname");
        }
        if (selectedAddresses.size() == 0) {
            String detectedIP = "";
            InetAddress loopbackAddress = null;
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                block7: while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (!inetAddress.isLoopbackAddress()) {
                            if (JeusNetProperties.DEFAULT_LOCAL_IP == null && JeusNetProperties.DEFAULT_LOCAL_HOSTNAME == null) {
                                selectedAddresses.add(inetAddress);
                                continue block7;
                            }
                            if (JeusNetPropertyValues.isAddressMatch(inetAddress)) {
                                selectedAddresses.add(inetAddress);
                                continue block7;
                            }
                            String localAddress = inetAddress.getHostAddress();
                            String hostName = inetAddress.getHostName();
                            detectedIP = detectedIP + hostName + "/" + localAddress + ", ";
                            continue;
                        }
                        loopbackAddress = inetAddress;
                    }
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            if (detectedIP.length() > 0) {
                detectedIP = detectedIP.substring(0, detectedIP.length() - 1 - 2);
            }
            if (selectedAddresses.size() == 0) {
                if (loopbackAddress != null && JeusNetPropertyValues.isAddressMatch(loopbackAddress)) {
                    selectedAddresses.add(loopbackAddress);
                } else {
                    throw new RuntimeException("No match local IP address : " + JeusNetProperties.DEFAULT_LOCAL_IP + ", detected ip : " + detectedIP);
                }
            }
        }
        String localHostName = JeusNetProperties.DEFAULT_LOCAL_HOSTNAME != null ? JeusNetProperties.DEFAULT_LOCAL_HOSTNAME : ((InetAddress)selectedAddresses.get(0)).getHostName();
        LOCAL_INETADDRESS = (InetAddress)selectedAddresses.get(0);
        LOCAL_HOSTADDRESS = LOCAL_INETADDRESS.getHostAddress();
        LOCAL_FULL_HOSTNAME = localHostName;
        LOCAL_HOSTNAME = localHostName.indexOf(46) != -1 ? localHostName.substring(0, localHostName.indexOf(46)) : localHostName;
    }
}

