/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.trace;

import java.io.Serializable;
import jeus.util.ByteUtil;

public class GID
implements Serializable {
    private static final long serialVersionUID = 5732754365746778465L;
    private static final ThreadLocal currentGID;
    public static boolean useGID;
    private static final int uniqueID;
    private int[] gid;
    private int seqNumber;
    public static final int GID_LENGTH = 8;
    public static final int SEQ_LENGTH = 4;
    public static final int GID_TOTAL_LENGTH = 12;
    private static final int BRANCH_UNIT = 65536;
    private String gidString;
    private byte[] gidBytes = new byte[8];
    private static final SynchronizedInt clientID;

    public GID() {
        clientID.commit(Integer.MAX_VALUE, 0);
        this.gid = new int[]{clientID.increment(), uniqueID};
        this.applyGID();
    }

    public GID(int[] gid) {
        this.gid = gid;
        this.applyGID();
    }

    public GID(int[] gid, int seqNumber) {
        this(gid);
        this.seqNumber = seqNumber;
    }

    public GID(byte[] gid, int seqNumber) {
        this(gid);
        this.seqNumber = seqNumber;
    }

    private void applyGID() {
        ByteUtil.putInt(this.gidBytes, 0, this.gid[0]);
        ByteUtil.putInt(this.gidBytes, 4, this.gid[1]);
        this.updateGIDString();
    }

    private void updateGIDString() {
        this.gidString = "0x" + ByteUtil.toHexString(this.gidBytes) + '-';
    }

    public GID(byte[] gid) {
        this.gid = new int[]{ByteUtil.convertToInt(gid, 0), ByteUtil.convertToInt(gid, 4)};
        this.applyGID();
    }

    public int[] getGid() {
        return this.gid;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[12];
        System.arraycopy(this.gidBytes, 0, bytes, 0, 8);
        ByteUtil.putInt(bytes, 8, this.seqNumber);
        return bytes;
    }

    public static GID getCurrentGID() {
        return (GID)currentGID.get();
    }

    public static String getCurrentGIDString() {
        return currentGID.get().toString();
    }

    public static void setCurrentGID(GID gid) {
        if (useGID) {
            currentGID.set(gid);
        }
    }

    public static void createCurrentGID() {
        if (useGID) {
            currentGID.set(new GID());
        }
    }

    public static void setCurrentGID(byte[] gidTotal) {
        if (useGID) {
            byte[] gid = new byte[8];
            System.arraycopy(gidTotal, 0, gid, 0, 8);
            int seqNumber = ByteUtil.convertToInt(gidTotal, 8);
            currentGID.set(new GID(gid, seqNumber));
        }
    }

    public static byte[] getCurrentGIDBytes() {
        GID gid = (GID)currentGID.get();
        if (gid == null) {
            return null;
        }
        return gid.toBytes();
    }

    public static void increaseSeqNumber() {
        if (useGID) {
            GID.increaseSeqNumber(1);
        }
    }

    private static void increaseSeqNumber(int increment) {
        GID gid = (GID)currentGID.get();
        if (gid == null) {
            return;
        }
        int seq = gid.getSeqNumber();
        gid.setSeqNumber(seq += increment);
    }

    public static void increaseBranchNumber() {
        if (useGID) {
            GID.increaseSeqNumber(65536);
        }
    }

    public void setSeqNumber(int newSeq) {
        this.seqNumber = newSeq;
    }

    public String toString() {
        return this.gidString + this.seqNumber;
    }

    public static void main(String[] args) {
        GID gid = new GID(new int[]{28, 48});
        GID.setCurrentGID(gid);
    }

    static {
        int id;
        String uniqueName;
        String gidPropertiesClass;
        currentGID = new InheritableThreadLocal();
        useGID = Boolean.getBoolean("tmax.apm.useGID");
        try {
            gidPropertiesClass = System.getProperty("gid.class");
        }
        catch (Exception ex) {
            gidPropertiesClass = null;
        }
        if (gidPropertiesClass == null) {
            gidPropertiesClass = "jeus.util.trace.GIDProperties";
        }
        try {
            Class<?> properties = GID.class.getClassLoader().loadClass(gidPropertiesClass);
            uniqueName = (String)properties.getField("UNIQUE_NAME").get(null);
            id = properties.getField("PRODUCT_ID").getInt(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        uniqueID = (uniqueName.hashCode() & 0xFFF0) + id;
        clientID = new SynchronizedInt(0);
    }

    private static class SynchronizedInt {
        private int value;

        public SynchronizedInt(int initial) {
            this.value = initial;
        }

        public synchronized void commit(int expected, int change) {
            this.value = this.value == expected ? change : this.value;
        }

        public synchronized int increment() {
            return ++this.value;
        }
    }
}

