/*
 * Decompiled with CFR 0.152.
 */
package jeus.workarea;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WorkArea;
import jeus.workarea.PropertyModeType;
import jeus.workarea.UserWorkAreaImpl;
import jeus.workarea.UserWorkAreaItem;
import jeus.workarea.UserWorkAreaPartition;
import jeus.workarea.UserWorkAreaValueItem;
import jeus.workarea.WorkAreaLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkAreaPropagationContext {
    private static final JeusLogger logger = WorkAreaLogger.logger;
    public static final String CONTEXT_NAME = "jeus.workarea.context";
    private static final String USERWORKAREA_NAME = "userworkarea";
    private static final String ITEM_NAME = "name";
    private static final String ITEM_VALUE = "item";

    static Map<String, Serializable> getCurrent() {
        UserWorkAreaPartition partition = UserWorkAreaImpl.getCurrent();
        if (partition == null || partition.size() == 0) {
            return null;
        }
        HashMap<String, Serializable> partitionMap = new HashMap<String, Serializable>(1);
        ArrayList stackList = new ArrayList();
        stackList.add(0, null);
        for (int i = 0; i < partition.size(); ++i) {
            UserWorkAreaItem item = (UserWorkAreaItem)partition.get(i);
            HashMap<String, Object> areaItemMap = new HashMap<String, Object>();
            areaItemMap.put(ITEM_NAME, item.getName());
            ArrayList<Serializable[]> valueItemList = new ArrayList<Serializable[]>();
            for (String key : item.keySet()) {
                UserWorkAreaValueItem valueItem = (UserWorkAreaValueItem)item.get(key);
                Serializable[] areaValueItem = new Serializable[]{key, valueItem.getValue(), valueItem.getMode()};
                valueItemList.add(areaValueItem);
            }
            areaItemMap.put(ITEM_VALUE, valueItemList);
            stackList.add(areaItemMap);
        }
        partitionMap.put(USERWORKAREA_NAME, stackList);
        if (logger.isLoggable(JeusMessage_WorkArea._1100_LEVEL)) {
            int stackSize = partition.size();
            String lastStackName = ((UserWorkAreaItem)partition.peek()).getName();
            logger.log(JeusMessage_WorkArea._1100_LEVEL, JeusMessage_WorkArea._1100, new Object[]{stackSize, lastStackName});
        }
        return partitionMap;
    }

    static void setPropagatedContext(Object context) {
        block7: {
            if (context == null) {
                return;
            }
            try {
                if (!(context instanceof Map)) {
                    throw new Exception("Propagated WorkArea context object " + context + " is not valid");
                }
                Map partitionMap = (Map)context;
                UserWorkAreaPartition userWorkArea = new UserWorkAreaPartition();
                ArrayList stackList = (ArrayList)partitionMap.get(USERWORKAREA_NAME);
                for (int i = 1; i < stackList.size(); ++i) {
                    Map areaItemMap = (Map)stackList.get(i);
                    String name = (String)areaItemMap.get(ITEM_NAME);
                    UserWorkAreaItem areaItem = new UserWorkAreaItem(name);
                    areaItem.setOriginated(false);
                    ArrayList valueList = (ArrayList)areaItemMap.get(ITEM_VALUE);
                    for (int j = 0; j < valueList.size(); ++j) {
                        Serializable[] valueItemArray = (Serializable[])valueList.get(j);
                        String key = (String)((Object)valueItemArray[0]);
                        Serializable value = valueItemArray[1];
                        PropertyModeType mode = (PropertyModeType)((Object)valueItemArray[2]);
                        UserWorkAreaValueItem valueItem = new UserWorkAreaValueItem(value, mode);
                        areaItem.put(key, valueItem);
                    }
                    userWorkArea.push(areaItem);
                }
                UserWorkAreaImpl.setCurrent(userWorkArea);
                if (logger.isLoggable(JeusMessage_WorkArea._1101_LEVEL)) {
                    int stackSize = userWorkArea.size();
                    String lastStackName = ((UserWorkAreaItem)userWorkArea.peek()).getName();
                    logger.log(JeusMessage_WorkArea._1101_LEVEL, JeusMessage_WorkArea._1101, new Object[]{stackSize, lastStackName});
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_WorkArea._1102_LEVEL)) break block7;
                logger.log(JeusMessage_WorkArea._1102_LEVEL, JeusMessage_WorkArea._1102, ex);
            }
        }
    }
}

