/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Base64 {
    private static final byte[] encodedChar = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final int BASELENGTH = 255;
    private static final int FOURBYTE = 4;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet = new byte[255];

    public static String encode(byte[] sourceBytes) {
        int srcLen = sourceBytes.length;
        int encLen = (srcLen + 2) / 3 * 4;
        byte[] encodedBytes = new byte[encLen];
        int i = 0;
        int j = 0;
        while (i < srcLen - 2) {
            encodedBytes[j] = encodedChar[sourceBytes[i] >>> 2 & 0x3F];
            encodedBytes[j + 1] = encodedChar[(sourceBytes[i] << 4 & 0x30) + (sourceBytes[i + 1] >>> 4 & 0xF)];
            encodedBytes[j + 2] = encodedChar[(sourceBytes[i + 1] << 2 & 0x3C) + (sourceBytes[i + 2] >>> 6 & 3)];
            encodedBytes[j + 3] = encodedChar[sourceBytes[i + 2] & 0x3F];
            i += 3;
            j += 4;
        }
        if (i == srcLen - 2) {
            encodedBytes[j] = encodedChar[sourceBytes[i] >>> 2 & 0x3F];
            encodedBytes[j + 1] = encodedChar[(sourceBytes[i] << 4 & 0x30) + (sourceBytes[i + 1] >>> 4 & 0xF)];
            encodedBytes[j + 2] = encodedChar[sourceBytes[i + 1] << 2 & 0x3C];
            encodedBytes[j + 3] = 61;
        }
        if (i == srcLen - 1) {
            encodedBytes[j] = encodedChar[sourceBytes[i] >>> 2 & 0x3F];
            encodedBytes[j + 1] = encodedChar[sourceBytes[i] << 4 & 0x30];
            encodedBytes[j + 2] = 61;
            encodedBytes[j + 3] = 61;
        }
        return new String(encodedBytes);
    }

    public static byte[] decode(String encodedStr) {
        int j;
        int i;
        byte[] encodedBytes = encodedStr.getBytes();
        int encLen = encodedBytes.length;
        int decLen = encLen / 4 * 3;
        byte[] decodedBytes = new byte[decLen];
        byte[] encodedByte = new byte[encLen];
        for (i = 0; i < encLen; ++i) {
            if (encodedBytes[i] == 61) {
                encodedByte[i] = 61;
            }
            for (j = 0; j < 64; ++j) {
                if (encodedChar[j] != encodedBytes[i]) continue;
                encodedByte[i] = (byte)j;
            }
        }
        i = 0;
        j = 0;
        while (i < encLen - 4) {
            decodedBytes[j] = (byte)((encodedByte[i] << 2 & 0xFC) + (encodedByte[i + 1] >>> 4 & 3));
            decodedBytes[j + 1] = (byte)((encodedByte[i + 1] << 4 & 0xF0) + (encodedByte[i + 2] >>> 2 & 0xF));
            decodedBytes[j + 2] = (byte)((encodedByte[i + 2] << 6 & 0xC0) + (encodedByte[i + 3] & 0x3F));
            i += 4;
            j += 3;
        }
        if (encodedByte[i + 2] == 61) {
            decodedBytes[j] = (byte)((encodedByte[i] << 2 & 0xFC) + (encodedByte[i + 1] >>> 4 & 3));
            decLen -= 2;
        } else if (encodedByte[i + 3] == 61) {
            decodedBytes[j] = (byte)((encodedByte[i] << 2 & 0xFC) + (encodedByte[i + 1] >>> 4 & 3));
            decodedBytes[j + 1] = (byte)((encodedByte[i + 1] << 4 & 0xF0) + (encodedByte[i + 2] >>> 2 & 0xF));
            --decLen;
        } else {
            decodedBytes[j] = (byte)((encodedByte[i] << 2 & 0xFC) + (encodedByte[i + 1] >>> 4 & 3));
            decodedBytes[j + 1] = (byte)((encodedByte[i + 1] << 4 & 0xF0) + (encodedByte[i + 2] >>> 2 & 0xF));
            decodedBytes[j + 2] = (byte)((encodedByte[i + 2] << 6 & 0xC0) + (encodedByte[i + 3] & 0x3F));
        }
        return decodedBytes;
    }

    public static String serialize(Object obj) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(bout);
            objOut.writeObject(obj);
            objOut.flush();
            objOut.close();
            return Base64.encode(bout.toByteArray());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static Object deserialize(String base64) {
        try {
            byte[] byteArray = Base64.decode(base64);
            ByteArrayInputStream bin = new ByteArrayInputStream(byteArray);
            ObjectInputStream objIn = new ObjectInputStream(bin);
            Object obj = objIn.readObject();
            objIn.close();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

