/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jeus.util.ReflectionUtils;
import jeus.xml.binding.util.JavaNamer;
import jeus.xml.binding.util.JeusBindingInterface;
import jeus.xml.util.DomProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class JeusBinding
implements Serializable {
    private HashMap infoMap;
    private ArrayList comments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getInfoMap() {
        if (this.infoMap == null) {
            JeusBinding jeusBinding = this;
            synchronized (jeusBinding) {
                if (this.infoMap == null) {
                    this.infoMap = new HashMap();
                }
            }
        }
        return this.infoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getComments() {
        if (this.comments == null) {
            JeusBinding jeusBinding = this;
            synchronized (jeusBinding) {
                if (this.comments == null) {
                    this.comments = new ArrayList();
                }
            }
        }
        return this.comments;
    }

    public String getElementId(String elementName) {
        return this._getElementId(JavaNamer.convert(elementName, true));
    }

    protected String _getElementId(String jaxbName) {
        return null;
    }

    public String getRootName(String dummy) {
        return null;
    }

    public void cloneType(JeusBinding target) {
        if (this.infoMap != null) {
            target.infoMap = (HashMap)this.infoMap.clone();
        }
        if (this.comments != null) {
            target.comments = (ArrayList)this.comments.clone();
        }
    }

    public static Document createDocument(JeusBinding binding, HashMap bindingMap) {
        String name = JeusBinding.getNameFromClass(binding.getClass());
        Document doc = DomProcessor.createEmptyDocument();
        Element root = binding.createElement(doc, name, bindingMap);
        bindingMap.put(root, binding);
        doc.appendChild(root);
        return doc;
    }

    public Element createElement(Document doc, String tagName, HashMap bindingMap) {
        Element element = doc.createElement(tagName);
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("is") && !method.getName().startsWith("get") || method.getName().startsWith("isSet") || method.getName().startsWith("unset") || method.getName().equals("getInfoMap") || method.getName().equals("getClass") || method.getName().equals("getPrimaryInterface") || method.getName().equals("getComments") || method.getName().equals("getElementId")) continue;
            String methodName = method.getName();
            String Name2 = null;
            Name2 = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
            String name = JeusBinding.getName(Name2);
            try {
                Boolean isSet = (Boolean)ReflectionUtils.invokeMethod((Object)this, "isSet" + Name2, null);
                if (!isSet.booleanValue()) continue;
                Object result = ReflectionUtils.invokeMethod((Object)this, methodName, null);
                if (result instanceof JeusBinding) {
                    JeusBinding binding = (JeusBinding)result;
                    Element child = binding.createElement(doc, name, bindingMap);
                    bindingMap.put(child, binding);
                    element.appendChild(child);
                    continue;
                }
                if (result instanceof List) {
                    List children = (List)result;
                    boolean choice = false;
                    if (name.indexOf("-or-") > 0) {
                        choice = true;
                    }
                    for (int j = 0; j < children.size(); ++j) {
                        Object o = children.get(j);
                        if (o instanceof JeusBinding) {
                            JeusBinding binding = (JeusBinding)o;
                            if (choice) {
                                name = JeusBinding.getNameFromClass(binding.getClass());
                            }
                            Element child = binding.createElement(doc, name, bindingMap);
                            bindingMap.put(child, binding);
                            element.appendChild(child);
                            continue;
                        }
                        element.appendChild(this.createElement(doc, name, o.toString()));
                    }
                    continue;
                }
                element.appendChild(this.createElement(doc, name, result.toString()));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return element;
    }

    public Element createElement(Document doc, String tagName, HashMap bindingMap, Object obj) {
        Element element = doc.createElement(tagName);
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("is") && !method.getName().startsWith("get") || method.getName().startsWith("isSet") || method.getName().startsWith("unset") || method.getName().equals("getInfoMap") || method.getName().equals("getClass") || method.getName().equals("getPrimaryInterface") || method.getName().equals("getComments") || method.getName().equals("getElementId")) continue;
            String methodName = method.getName();
            String Name2 = null;
            Name2 = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
            String name = JeusBinding.getName(Name2);
            try {
                Boolean isSet = (Boolean)ReflectionUtils.invokeMethod(obj, "isSet" + Name2, null);
                if (!isSet.booleanValue()) continue;
                Object result = ReflectionUtils.invokeMethod(obj, methodName, null);
                if (result instanceof JeusBindingInterface) {
                    JeusBindingInterface binding = (JeusBindingInterface)result;
                    Element child = binding.createElement(doc, name, bindingMap);
                    bindingMap.put(child, binding);
                    element.appendChild(child);
                    continue;
                }
                if (result instanceof List) {
                    List children = (List)result;
                    boolean choice = false;
                    if (name.indexOf("-or-") > 0) {
                        choice = true;
                    }
                    for (int j = 0; j < children.size(); ++j) {
                        Object o = children.get(j);
                        if (o instanceof JeusBindingInterface) {
                            JeusBindingInterface binding = (JeusBindingInterface)o;
                            if (choice) {
                                name = JeusBinding.getElementNameFromClass(binding.getClass());
                            }
                            Element child = binding.createElement(doc, name, bindingMap);
                            bindingMap.put(child, binding);
                            element.appendChild(child);
                            continue;
                        }
                        element.appendChild(this.createElement(doc, name, o.toString()));
                    }
                    continue;
                }
                element.appendChild(this.createElement(doc, name, result.toString()));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return element;
    }

    public static String getNameFromClass(Class clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        if ((p = name.lastIndexOf(36)) >= 0) {
            name = name.substring(p + 1);
        }
        if (name.endsWith("Impl")) {
            name = name.substring(0, name.length() - 4);
        }
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return JeusBinding.getName(name);
    }

    public static String getElementNameFromClass(Class clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        if ((p = name.lastIndexOf(36)) >= 0) {
            name = name.substring(p + 1);
        }
        if (name.endsWith("Type")) {
            name = name.substring(0, name.length() - 4);
        }
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return JeusBinding.getName(name);
    }

    private static String getName(String Name2) {
        char[] charr = Name2.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < charr.length; ++i) {
            if (Character.isUpperCase(charr[i])) {
                if (i > 0) {
                    buf.append("-");
                }
                buf.append(Character.toLowerCase(charr[i]));
                continue;
            }
            buf.append(charr[i]);
        }
        return buf.toString();
    }

    private Element createElement(Document doc, String tagName, String data) {
        Element element = doc.createElement(tagName);
        Text text = doc.createTextNode(data);
        element.appendChild(text);
        return element;
    }
}

