/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class DomProcessor {
    private static final String FORMAT_PRETTY_PRINT = "format-pretty-print";
    private static DOMImplementation implementation;
    private static DOMImplementationLS feature;
    private static TransformerFactory transformerFactory;

    public static Document parse(InputStream is) {
        LSInput input = feature.createLSInput();
        input.setByteStream(is);
        LSParser parser = feature.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
        return parser.parse(input);
    }

    public static Document parse(Reader r) {
        LSInput input = feature.createLSInput();
        input.setCharacterStream(r);
        LSParser parser = feature.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
        return parser.parse(input);
    }

    public static void serialize(Node node, OutputStream os) {
        LSSerializer serializer;
        DOMConfiguration domConfig;
        boolean canUseDomL3Beautify;
        String encoding = null;
        if (node instanceof Document) {
            encoding = ((Document)node).getXmlEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (canUseDomL3Beautify = (domConfig = (serializer = feature.createLSSerializer()).getDomConfig()).canSetParameter(FORMAT_PRETTY_PRINT, Boolean.TRUE)) {
            LSOutput output = feature.createLSOutput();
            output.setEncoding(encoding);
            output.setByteStream(os);
            domConfig.setParameter(FORMAT_PRETTY_PRINT, Boolean.TRUE);
            serializer.write(node, output);
        } else {
            DomProcessor.serializeByTransformer(node, os, encoding);
        }
    }

    private static void serializeByTransformer(Node node, OutputStream os, String encoding) {
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(new OutputStreamWriter(os, encoding)));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document refreshDocument(Document doc) {
        Document resultDoc = null;
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            resultDoc = DomProcessor.createEmptyDocument();
            transformer.transform(new DOMSource(doc), new DOMResult(resultDoc));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return resultDoc;
    }

    public static Document createEmptyDocument() {
        return implementation.createDocument(null, null, null);
    }

    static {
        transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", new Integer(4));
        try {
            implementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0 Traversal +Events 2.0");
            if (implementation == null && System.getProperty("org.w3c.dom.DOMImplementationSourceList") == null) {
                System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
            }
            if ((implementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0 Traversal +Events 2.0")) == null) {
                implementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
            }
            assert (implementation != null);
            feature = (DOMImplementationLS)implementation.getFeature("LS", "3.0");
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

