/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
    private static final JBTreeTraverser<Class> CLASS_TRAVERSER = JBTreeTraverser.from(new Function<Class, Iterable<Class>>(){

        @Override
        public Iterable<Class> fun(Class aClass2) {
            return JBIterable.of(aClass2.getSuperclass()).append(aClass2.getInterfaces());
        }
    });

    private ReflectionUtil() {
    }

    @NotNull
    public static Field findField(@NotNull Class clazz, final @Nullable Class type2, final @NotNull String name) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(17);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(18);
        }
        if ((result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName()) && (type2 == null || field.getType().equals(type2));
            }
        })) != null) {
            Field field = result2;
            if (field == null) {
                ReflectionUtil.$$$reportNull$$$0(19);
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type2);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, final @Nullable(value="null means any type") Class<?> fieldType, final @NotNull String fieldName) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(20);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(21);
        }
        if ((result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType()));
            }
        })) != null) {
            Field field = result2;
            if (field == null) {
                ReflectionUtil.$$$reportNull$$$0(22);
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    private static Field processFields(@NotNull Class clazz, @NotNull Condition<Field> checker) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(23);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(24);
        }
        for (Class c : ReflectionUtil.classTraverser(clazz)) {
            Field field = JBIterable.of(c.getDeclaredFields()).find(checker);
            if (field == null) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public static void resetField(@NotNull Class clazz, @Nullable(value="null means of any type") Class type2, @NotNull String name) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(25);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(26);
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type2, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(31);
        }
        field.setAccessible(true);
        Class<?> type2 = field.getType();
        try {
            if (type2.isPrimitive()) {
                if (Boolean.TYPE.equals(type2)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type2)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type2)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type2)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods2, @NonNls @NotNull String name, Class ... parameters2) {
        if (methods2 == null) {
            ReflectionUtil.$$$reportNull$$$0(34);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(35);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(36);
        }
        for (Method method : methods2) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters2, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass2, @NonNls @NotNull String name, Class ... parameters2) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(38);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(39);
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassPublicMethods(aClass2, false), name, parameters2);
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass2, @NonNls @NotNull String name, Class ... parameters2) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(40);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(41);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(42);
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassDeclaredMethods(aClass2, false), name, parameters2);
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class aClass2, final @NonNls @NotNull String name) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(43);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(44);
        }
        return ReflectionUtil.processFields(aClass2, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName());
            }
        });
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class aClass2, boolean includeSynthetic) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(47);
        }
        Method[] methods2 = aClass2.getMethods();
        List<Method> list2 = includeSynthetic ? Arrays.asList(methods2) : ReflectionUtil.filterRealMethods(methods2);
        if (list2 == null) {
            ReflectionUtil.$$$reportNull$$$0(48);
        }
        return list2;
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class aClass2, boolean includeSynthetic) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(51);
        }
        Method[] methods2 = aClass2.getDeclaredMethods();
        List<Method> list2 = includeSynthetic ? Arrays.asList(methods2) : ReflectionUtil.filterRealMethods(methods2);
        if (list2 == null) {
            ReflectionUtil.$$$reportNull$$$0(52);
        }
        return list2;
    }

    @NotNull
    private static List<Method> filterRealMethods(@NotNull Method[] methods2) {
        if (methods2 == null) {
            ReflectionUtil.$$$reportNull$$$0(55);
        }
        ArrayList<Method> result2 = ContainerUtil.newArrayList();
        for (Method method : methods2) {
            if (method.isSynthetic()) continue;
            result2.add(method);
        }
        ArrayList<Method> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    @Nullable
    public static Class getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class ... parameters2) {
        Method method;
        if (instanceClass == null) {
            ReflectionUtil.$$$reportNull$$$0(57);
        }
        if (methodName == null) {
            ReflectionUtil.$$$reportNull$$$0(58);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(59);
        }
        return (method = ReflectionUtil.getMethod(instanceClass, methodName, parameters2)) == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(60);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(61);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            Object t = field.get(object);
            return (T)t;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class objectClass, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(62);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(63);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            Object t = field.get(null);
            return (T)t;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass2) {
        Constructor<T> constructor;
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(68);
        }
        try {
            Constructor<T> constructor2 = aClass2.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass2, e);
        }
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(69);
        }
        return constructor;
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass2) {
        Constructor<T> constructor;
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(70);
        }
        try {
            constructor = aClass2.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                T t = aClass2.newInstance();
                if (t == null) {
                    ReflectionUtil.$$$reportNull$$$0(71);
                }
                return t;
            }
        }
        catch (Exception e) {
            T t = ReflectionUtil.createAsDataClass(aClass2);
            if (t != null) {
                T t2 = t;
                if (t2 == null) {
                    ReflectionUtil.$$$reportNull$$$0(73);
                }
                return t2;
            }
            ExceptionUtil.rethrow(e);
            if (null == null) {
                ReflectionUtil.$$$reportNull$$$0(74);
            }
            return null;
        }
        T t = constructor.newInstance(new Object[0]);
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(72);
        }
        return t;
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            ReflectionUtil.$$$reportNull$$$0(75);
        }
        for (Annotation annotation2 : aClass2.getAnnotations()) {
            String name = annotation2.annotationType().getName();
            if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors2 = aClass2.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor : constructors2) {
                try {
                    block14: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        for (Class<?> type2 : parameterTypes = constructor.getParameterTypes()) {
                            if (!type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block14;
                        }
                        return (T)constructor.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            for (Constructor constructor : defaultCtors) {
                try {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(76);
        }
        if (args == null) {
            ReflectionUtil.$$$reportNull$$$0(77);
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(78);
        }
        return t;
    }

    @Nullable
    public static Class getGrandCallerClass() {
        int stackFrameCount = 3;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(2);
        }
        return callerClass;
    }

    @Nullable
    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            ReflectionUtil.$$$reportNull$$$0(92);
        }
        if (descendant == null) {
            ReflectionUtil.$$$reportNull$$$0(93);
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    @NotNull
    public static JBTreeTraverser<Class> classTraverser(@Nullable Class root2) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)CLASS_TRAVERSER.unique()).withRoot(root2);
        if (jBTreeTraverser == null) {
            ReflectionUtil.$$$reportNull$$$0(94);
        }
        return jBTreeTraverser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 91: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 91: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 91: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizedType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 18: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 61: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 31: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 32: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 67: 
            case 68: 
            case 70: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 34: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 36: 
            case 39: 
            case 42: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClass";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 60: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 80: 
            case 83: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 81: 
            case 84: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationToString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualTypeArguments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findField";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssignableField";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPublicMethods";
                break;
            }
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclaredMethods";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclaredFields";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRealMethods";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructor";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "forName";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "classTraverser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declarationToString";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 91: 
            case 94: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRawType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActualTypeArguments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "substituteGenericType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findAssignableField";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processFields";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resetField";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resetStaticField";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredField";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getClassPublicMethods";
                break;
            }
            case 49: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredMethods";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredFields";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "filterRealMethods";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclaringClass";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFieldValue";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariableInHierarchy";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createAsDataClass";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "copyFields";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "comparePublicNonFinalFields";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldValue";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "forName";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 91: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

