/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalRdbms;
import com.google.appengine.api.rdbms.dev.LocalRdbmsServiceLocalDriver;
import com.google.appengine.api.rdbms.dev.LocalRdbmsServiceRemoteDriver;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@ServiceProvider(value=LocalRpcService.class)
public class LocalRdbmsService
extends AbstractLocalRpcService
implements LocalRdbms {
    private static final Logger logger = Logger.getLogger(LocalRdbmsService.class.getCanonicalName());
    static final double RDBMS_API_DEADLINE = 60.0;
    static final Integer MAX_API_REQUEST_SIZE = 0x1000000;
    public static final String PACKAGE = "rdbms";
    public static final String SERVER_TYPE = "rdbms.server";
    public static final String RDBMS_PROPERTIES_FILE = "rdbms.properties.file";
    LocalRdbms delegate;

    public void init(LocalServiceContext context, Map<String, String> properties) {
        if (properties.containsKey(RDBMS_PROPERTIES_FILE)) {
            this.mergePropertiesFromFile(properties.get(RDBMS_PROPERTIES_FILE), properties);
        }
        this.delegate = this.createDelegate(properties);
        this.delegate.init(context, properties);
    }

    public final String getPackage() {
        return PACKAGE;
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return this.delegate.getDefaultDeadline(isOfflineRequest);
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return this.delegate.getMaximumDeadline(isOfflineRequest);
    }

    public Integer getMaxApiRequestSize() {
        return this.delegate.getMaxApiRequestSize();
    }

    @Override
    public OpenConnectionResponse openConnection(LocalRpcService.Status status, OpenConnectionRequest request) {
        try {
            return this.delegate.openConnection(status, request);
        }
        catch (RuntimeException e) {
            throw LocalRdbmsService.handleRuntimeException(e, "OpenConnection");
        }
    }

    @Override
    public CloseConnectionResponse closeConnection(LocalRpcService.Status status, CloseConnectionRequest request) {
        try {
            return this.delegate.closeConnection(status, request);
        }
        catch (RuntimeException e) {
            throw LocalRdbmsService.handleRuntimeException(e, "CloseConnection");
        }
    }

    @Override
    public ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        try {
            return this.delegate.exec(status, request);
        }
        catch (RuntimeException e) {
            throw LocalRdbmsService.handleRuntimeException(e, "Exec");
        }
    }

    @Override
    public ExecOpResponse execOp(LocalRpcService.Status status, ExecOpRequest request) {
        try {
            return this.delegate.execOp(status, request);
        }
        catch (RuntimeException e) {
            throw LocalRdbmsService.handleRuntimeException(e, "ExecOp");
        }
    }

    @Override
    public MetadataResponse getMetadata(LocalRpcService.Status status, MetadataRequest request) {
        try {
            return this.delegate.getMetadata(status, request);
        }
        catch (RuntimeException e) {
            throw LocalRdbmsService.handleRuntimeException(e, "GetMetadata");
        }
    }

    protected LocalRdbms createDelegate(Map<String, String> properties) {
        ServerType serverType = ServerType.fromFlagValue(properties.get(SERVER_TYPE));
        switch (serverType) {
            case LOCAL: {
                return new LocalRdbmsServiceLocalDriver();
            }
            case HOSTED: {
                return new LocalRdbmsServiceRemoteDriver();
            }
        }
        throw new IllegalStateException(MessageFormat.format("Unknown Server type {0}", new Object[]{serverType}));
    }

    private static RuntimeException handleRuntimeException(RuntimeException e, String methodName) {
        if (e instanceof ApiProxy.ApplicationException) {
            throw e;
        }
        logger.log(Level.SEVERE, "Unexpected exception", e);
        throw new ApiProxy.UnknownException(PACKAGE, methodName, (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergePropertiesFromFile(String fileName, Map<String, String> properties) {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File %s does not exist.", fileName));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(String.format("Can not read File %s.", fileName));
        }
        Properties fileProps = new Properties();
        try (FileReader reader = new FileReader(file);){
            fileProps.load(reader);
            for (Map.Entry<Object, Object> e : fileProps.entrySet()) {
                String key = String.valueOf(e.getKey());
                if (properties.containsKey(key)) continue;
                properties.put(key, String.valueOf(e.getValue()));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to load properties from %s.", fileName), e);
        }
    }

    public static enum ServerType {
        HOSTED,
        LOCAL;

        static final ServerType DEFAULT;

        public String flagValue() {
            return this.name().toLowerCase();
        }

        public static ServerType fromFlagValue(String flagValue) {
            if (flagValue == null) {
                return DEFAULT;
            }
            return ServerType.valueOf(flagValue.toUpperCase());
        }

        static {
            DEFAULT = LOCAL;
        }
    }
}

