/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import java.io.Serializable;

@GwtCompatible(serializable=true)
public strictfp final class S1ChordAngle
implements Comparable<S1ChordAngle>,
Serializable {
    public static final S1ChordAngle ZERO = new S1ChordAngle(0.0);
    public static final S1ChordAngle STRAIGHT = new S1ChordAngle(4.0);
    public static final S1ChordAngle INFINITY = new S1ChordAngle(Double.POSITIVE_INFINITY);
    public static final S1ChordAngle NEGATIVE = new S1ChordAngle(-1.0);
    private final double length2;

    public S1ChordAngle(S2Point x, S2Point y) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(x));
        Preconditions.checkArgument((boolean)S2.isUnitLength(y));
        this.length2 = Math.min(4.0, x.getDistance2(y));
        Preconditions.checkArgument((boolean)this.isValid());
    }

    public static S1ChordAngle fromS1Angle(S1Angle angle) {
        if (angle.radians() < 0.0) {
            return NEGATIVE;
        }
        if (angle.equals(S1Angle.INFINITY)) {
            return INFINITY;
        }
        double length = 2.0 * Math.sin(0.5 * Math.min(Math.PI, angle.radians()));
        return new S1ChordAngle(length * length);
    }

    private S1ChordAngle(double length2) {
        this.length2 = length2;
        Preconditions.checkArgument((boolean)this.isValid());
    }

    public static S1ChordAngle fromLength2(double length2) {
        return new S1ChordAngle(Math.min(4.0, length2));
    }

    public boolean isZero() {
        return this.length2 == 0.0;
    }

    public boolean isNegative() {
        return this.length2 < 0.0;
    }

    public boolean isInfinity() {
        return this.length2 == Double.POSITIVE_INFINITY;
    }

    public boolean isSpecial() {
        return this.isNegative() || this.isInfinity();
    }

    public boolean isValid() {
        return this.length2 >= 0.0 && this.length2 <= 4.0 || this.isNegative() || this.isInfinity();
    }

    public S1Angle toAngle() {
        if (this.isNegative()) {
            return S1Angle.radians(-1.0);
        }
        if (this.isInfinity()) {
            return S1Angle.INFINITY;
        }
        return S1Angle.radians(2.0 * Math.asin(0.5 * Math.sqrt(this.length2)));
    }

    public double getLength2() {
        return this.length2;
    }

    public static S1ChordAngle add(S1ChordAngle a, S1ChordAngle b) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        Preconditions.checkArgument((!b.isSpecial() ? 1 : 0) != 0);
        double a2 = a.length2;
        double b2 = b.length2;
        if (b2 == 0.0) {
            return a;
        }
        if (a2 + b2 >= 4.0) {
            return STRAIGHT;
        }
        double x = a2 * (1.0 - 0.25 * b2);
        double y = b2 * (1.0 - 0.25 * a2);
        return new S1ChordAngle(Math.min(4.0, x + y + 2.0 * Math.sqrt(x * y)));
    }

    public static S1ChordAngle sub(S1ChordAngle a, S1ChordAngle b) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        Preconditions.checkArgument((!b.isSpecial() ? 1 : 0) != 0);
        double a2 = a.length2;
        double b2 = b.length2;
        if (b2 == 0.0) {
            return a;
        }
        if (a2 <= b2) {
            return ZERO;
        }
        double x = a2 * (1.0 - 0.25 * b2);
        double y = b2 * (1.0 - 0.25 * a2);
        return new S1ChordAngle(Math.max(0.0, x + y - 2.0 * Math.sqrt(x * y)));
    }

    public static double sin(S1ChordAngle a) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        double sin2 = a.length2 * (1.0 - 0.25 * a.length2);
        return Math.sqrt(sin2);
    }

    public static double cos(S1ChordAngle a) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        return 1.0 - 0.5 * a.length2;
    }

    public static double tan(S1ChordAngle a) {
        return S1ChordAngle.sin(a) / S1ChordAngle.cos(a);
    }

    public String toString() {
        return this.toAngle().toString();
    }

    @Override
    public int compareTo(S1ChordAngle that) {
        return Double.compare(this.length2, that.length2);
    }

    public boolean equals(Object other) {
        return other instanceof S1ChordAngle && this.length2 == ((S1ChordAngle)other).length2;
    }
}

