/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.io;

import com.google.appengine.repackaged.org.apache.http.annotation.NotThreadSafe;
import com.google.appengine.repackaged.org.apache.http.io.BufferInfo;
import com.google.appengine.repackaged.org.apache.http.io.SessionInputBuffer;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
public class IdentityInputStream
extends InputStream {
    private final SessionInputBuffer in;
    private boolean closed = false;

    public IdentityInputStream(SessionInputBuffer in) {
        if (in == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        this.in = in;
    }

    public int available() throws IOException {
        if (this.in instanceof BufferInfo) {
            return ((BufferInfo)((Object)this.in)).length();
        }
        return 0;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.in.read(b, off, len);
    }
}

