/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.nio;

import com.google.appengine.repackaged.org.apache.http.HttpRequestFactory;
import com.google.appengine.repackaged.org.apache.http.annotation.Immutable;
import com.google.appengine.repackaged.org.apache.http.impl.DefaultHttpRequestFactory;
import com.google.appengine.repackaged.org.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.google.appengine.repackaged.org.apache.http.nio.NHttpConnectionFactory;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.IOSession;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.ssl.SSLIOSession;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.ssl.SSLMode;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.google.appengine.repackaged.org.apache.http.nio.util.ByteBufferAllocator;
import com.google.appengine.repackaged.org.apache.http.nio.util.HeapByteBufferAllocator;
import com.google.appengine.repackaged.org.apache.http.params.HttpConnectionParams;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SSLNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final HttpRequestFactory requestFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final HttpParams params;

    public SSLNHttpServerConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        if (requestFactory == null) {
            throw new IllegalArgumentException("HTTP request factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
        this.requestFactory = requestFactory;
        this.allocator = allocator;
        this.params = params;
    }

    public SSLNHttpServerConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, new DefaultHttpRequestFactory(), new HeapByteBufferAllocator(), params);
    }

    public SSLNHttpServerConnectionFactory(HttpParams params) {
        this(null, null, params);
    }

    private SSLContext getDefaultSSLContext() {
        SSLContext sslcontext;
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failure initializing default SSL context", ex);
        }
        return sslcontext;
    }

    protected DefaultNHttpServerConnection createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession session) {
        SSLContext sslcontext = this.sslcontext != null ? this.sslcontext : this.getDefaultSSLContext();
        SSLIOSession ssliosession = new SSLIOSession(session, SSLMode.SERVER, sslcontext, this.sslHandler);
        session.setAttribute("http.session.ssl", ssliosession);
        DefaultNHttpServerConnection conn = this.createConnection(ssliosession, this.requestFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout(this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }
}

