/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.nio.pool;

import com.google.appengine.repackaged.org.apache.http.annotation.Immutable;
import com.google.appengine.repackaged.org.apache.http.concurrent.BasicFuture;
import com.google.appengine.repackaged.org.apache.http.pool.PoolEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class LeaseRequest<T, C, E extends PoolEntry<T, C>> {
    private final T route;
    private final Object state;
    private final long connectTimeout;
    private final long deadline;
    private final BasicFuture<E> future;

    public LeaseRequest(T route, Object state, long connectTimeout, BasicFuture<E> future) {
        this.route = route;
        this.state = state;
        this.connectTimeout = connectTimeout;
        this.deadline = connectTimeout > 0L ? System.currentTimeMillis() + connectTimeout : Long.MAX_VALUE;
        this.future = future;
    }

    public T getRoute() {
        return this.route;
    }

    public Object getState() {
        return this.state;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public BasicFuture<E> getFuture() {
        return this.future;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        buffer.append(this.route);
        buffer.append("][");
        buffer.append(this.state);
        buffer.append("]");
        return buffer.toString();
    }
}

