/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.util.AttributeSource;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CachingTokenFilter
extends TokenFilter {
    private List cache = null;
    private Iterator iterator = null;
    private AttributeSource.State finalState;

    public CachingTokenFilter(TokenStream input) {
        super(input);
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public final boolean incrementToken() throws IOException {
        if (this.cache == null) {
            this.cache = new LinkedList();
            this.fillCache();
            this.iterator = this.cache.iterator();
        }
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.restoreState((AttributeSource.State)this.iterator.next());
        return true;
    }

    public final void end() throws IOException {
        if (this.finalState != null) {
            this.restoreState(this.finalState);
        }
    }

    public void reset() throws IOException {
        if (this.cache != null) {
            this.iterator = this.cache.iterator();
        }
    }

    private void fillCache() throws IOException {
        while (this.input.incrementToken()) {
            this.cache.add(this.captureState());
        }
        this.input.end();
        this.finalState = this.captureState();
    }
}

