/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.ru;

import com.google.appengine.repackaged.org.apache.lucene.analysis.CharTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.ru.RussianCharsets;
import com.google.appengine.repackaged.org.apache.lucene.util.AttributeSource;
import java.io.Reader;

public class RussianLetterTokenizer
extends CharTokenizer {
    private char[] charset;

    public RussianLetterTokenizer(Reader in, char[] charset) {
        super(in);
        this.charset = charset;
    }

    public RussianLetterTokenizer(Reader in) {
        this(in, RussianCharsets.UnicodeRussian);
    }

    public RussianLetterTokenizer(AttributeSource source, Reader in) {
        super(source, in);
        this.charset = RussianCharsets.UnicodeRussian;
    }

    public RussianLetterTokenizer(AttributeSource.AttributeFactory factory, Reader in) {
        super(factory, in);
        this.charset = RussianCharsets.UnicodeRussian;
    }

    protected boolean isTokenChar(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        for (int i = 0; i < this.charset.length; ++i) {
            if (c != this.charset[i]) continue;
            return true;
        }
        return false;
    }
}

