/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.search.CachingWrapperFilter;
import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSet;
import com.google.appengine.repackaged.org.apache.lucene.search.SpanFilter;
import com.google.appengine.repackaged.org.apache.lucene.search.SpanFilterResult;
import java.io.IOException;
import java.util.BitSet;

public class CachingSpanFilter
extends SpanFilter {
    protected SpanFilter filter;
    private final CachingWrapperFilter.FilterCache cache;
    int hitCount;
    int missCount;

    public CachingSpanFilter(SpanFilter filter) {
        this(filter, CachingWrapperFilter.DeletesMode.RECACHE);
    }

    public CachingSpanFilter(SpanFilter filter, CachingWrapperFilter.DeletesMode deletesMode) {
        this.filter = filter;
        if (deletesMode == CachingWrapperFilter.DeletesMode.DYNAMIC) {
            throw new IllegalArgumentException("DeletesMode.DYNAMIC is not supported");
        }
        this.cache = new CachingWrapperFilter.FilterCache(deletesMode){

            protected Object mergeDeletes(IndexReader r, Object value) {
                throw new IllegalStateException("DeletesMode.DYNAMIC is not supported");
            }
        };
    }

    public BitSet bits(IndexReader reader) throws IOException {
        SpanFilterResult result = this.getCachedResult(reader);
        return result != null ? result.getBits() : null;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        SpanFilterResult result = this.getCachedResult(reader);
        return result != null ? result.getDocIdSet() : null;
    }

    private SpanFilterResult getCachedResult(IndexReader reader) throws IOException {
        Object delCoreKey;
        Object coreKey = reader.getFieldCacheKey();
        SpanFilterResult result = (SpanFilterResult)this.cache.get(reader, coreKey, delCoreKey = reader.hasDeletions() ? reader.getDeletesCacheKey() : coreKey);
        if (result != null) {
            ++this.hitCount;
            return result;
        }
        ++this.missCount;
        result = this.filter.bitSpans(reader);
        this.cache.put(coreKey, delCoreKey, result);
        return result;
    }

    public SpanFilterResult bitSpans(IndexReader reader) throws IOException {
        return this.getCachedResult(reader);
    }

    public String toString() {
        return "CachingSpanFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingSpanFilter)) {
            return false;
        }
        return this.filter.equals(((CachingSpanFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

