/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.io.UnsupportedEncodingException;
import mediautil.gen.BasicIo;

public class BasicJpegIo
extends BasicIo {
    static final byte M_SOF0 = -64;
    static final byte M_SOF1 = -63;
    static final byte M_SOF2 = -62;
    static final byte M_SOF3 = -61;
    public final byte M_DHT = (byte)-60;
    static final byte M_SOF5 = -59;
    static final byte M_SOF6 = -58;
    static final byte M_SOF7 = -57;
    static final byte M_JPG = -56;
    static final byte M_SOF9 = -55;
    static final byte M_SOF10 = -54;
    static final byte M_SOF11 = -53;
    static final byte M_SOF13 = -51;
    static final byte M_SOF14 = -50;
    static final byte M_SOF15 = -49;
    static final byte M_RST0 = -48;
    static final byte M_RST1 = -47;
    static final byte M_RST2 = -46;
    static final byte M_RST3 = -45;
    static final byte M_RST4 = -44;
    static final byte M_RST5 = -43;
    static final byte M_RST6 = -42;
    static final byte M_RST7 = -41;
    static final byte M_SOI = -40;
    static final byte M_EOI = -39;
    static final byte M_SOS = -38;
    public final byte M_DQT = (byte)-37;
    public final byte M_DNL = (byte)-36;
    public final byte M_DRI = (byte)-35;
    public final byte M_DHP = (byte)-34;
    public final byte M_EXP = (byte)-33;
    static final byte M_APP0 = -32;
    static final byte M_APP12 = -20;
    static final byte M_COM = -2;
    static final byte M_PRX = -1;
    boolean intel;
    boolean motorola;
    protected byte[] data;

    int i2bsI(int offset, int value, int length) {
        int i = 0;
        int s = 0;
        while (i < length) {
            this.data[offset + i] = (byte)(value >> s);
            ++i;
            s += 8;
        }
        return offset + length;
    }

    int bs2i(int offset, int length) {
        int val = 0;
        for (int i = 0; i < length; ++i) {
            val = (val << 8) + (this.data[offset + i] & 0xFF);
        }
        return val;
    }

    int s2n(int offset, int length) {
        return this.s2n(offset, length, false);
    }

    int s2n(int offset, int length, boolean signed) {
        return BasicJpegIo.s2n(this.data, offset, length, signed, this.intel);
    }

    void n2s(byte[] result, int offset, int value, int length) {
        if (this.motorola) {
            for (int i = 0; i < length; ++i) {
                result[offset + length - i - 1] = (byte)(value & 0xFF);
                value >>= 8;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                result[offset + i] = (byte)(value & 0xFF);
                value >>= 8;
            }
        }
    }

    byte[] n2s(int value, int length) {
        byte[] result = new byte[length];
        this.n2s(result, 0, value, length);
        return result;
    }

    String s2a(int offset, int length) {
        String result = null;
        try {
            result = new String(this.data, offset, length, "Default");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return result;
    }

    boolean isSignature(int offset, String signature) {
        return BasicJpegIo.isSignature(this.data, offset, signature);
    }
}

