/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.taglibs.standard.lang.jstl.BeanInfoManager;
import org.apache.taglibs.standard.lang.jstl.BeanInfoProperty;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.ValueSuffix;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class ArraySuffix
extends ValueSuffix {
    static Object[] sNoArgs = new Object[0];
    Expression mIndex;

    public Expression getIndex() {
        return this.mIndex;
    }

    public void setIndex(Expression expression) {
        this.mIndex = expression;
    }

    public ArraySuffix(Expression expression) {
        this.mIndex = expression;
    }

    Object evaluateIndex(Object object, VariableResolver variableResolver, Map map, String string, Logger logger) throws ELException {
        return this.mIndex.evaluate(object, variableResolver, map, string, logger);
    }

    String getOperatorSymbol() {
        return "[]";
    }

    @Override
    public String getExpressionString() {
        return "[" + this.mIndex.getExpressionString() + "]";
    }

    @Override
    public Object evaluate(Object object, Object object2, VariableResolver variableResolver, Map map, String string, Logger logger) throws ELException {
        if (object == null) {
            if (logger.isLoggingWarning()) {
                logger.logWarning(Constants.CANT_GET_INDEXED_VALUE_OF_NULL, this.getOperatorSymbol());
            }
            return null;
        }
        Object object3 = this.evaluateIndex(object2, variableResolver, map, string, logger);
        if (object3 == null) {
            if (logger.isLoggingWarning()) {
                logger.logWarning(Constants.CANT_GET_NULL_INDEX, this.getOperatorSymbol());
            }
            return null;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return map2.get(object3);
        }
        if (object instanceof List || object.getClass().isArray()) {
            Integer n = Coercions.coerceToInteger(object3, logger);
            if (n == null) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.BAD_INDEX_VALUE, this.getOperatorSymbol(), (Object)object3.getClass().getName());
                }
                return null;
            }
            if (object instanceof List) {
                try {
                    return ((List)object).get(n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (logger.isLoggingWarning()) {
                        logger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, arrayIndexOutOfBoundsException, (Object)n);
                    }
                    return null;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (logger.isLoggingWarning()) {
                        logger.logWarning(Constants.EXCEPTION_ACCESSING_LIST, indexOutOfBoundsException, (Object)n);
                    }
                    return null;
                }
                catch (Exception exception) {
                    if (logger.isLoggingError()) {
                        logger.logError(Constants.EXCEPTION_ACCESSING_LIST, exception, (Object)n);
                    }
                    return null;
                }
            }
            try {
                return Array.get(object, n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (logger.isLoggingWarning()) {
                    logger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, arrayIndexOutOfBoundsException, (Object)n);
                }
                return null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (logger.isLoggingWarning()) {
                    logger.logWarning(Constants.EXCEPTION_ACCESSING_ARRAY, indexOutOfBoundsException, (Object)n);
                }
                return null;
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.EXCEPTION_ACCESSING_ARRAY, exception, (Object)n);
                }
                return null;
            }
        }
        String string2 = Coercions.coerceToString(object3, logger);
        if (string2 == null) {
            return null;
        }
        BeanInfoProperty beanInfoProperty = BeanInfoManager.getBeanInfoProperty(object.getClass(), string2, logger);
        if (beanInfoProperty != null && beanInfoProperty.getReadMethod() != null) {
            try {
                return beanInfoProperty.getReadMethod().invoke(object, sNoArgs);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.ERROR_GETTING_PROPERTY, invocationTargetException.getTargetException(), (Object)string2, (Object)object.getClass().getName());
                }
                return null;
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.ERROR_GETTING_PROPERTY, exception, (Object)string2, (Object)object.getClass().getName());
                }
                return null;
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.CANT_FIND_INDEX, object3, (Object)object.getClass().getName(), (Object)this.getOperatorSymbol());
        }
        return null;
    }
}

