/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.apache.taglibs.standard.lang.jstl.ArithmeticOperator;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.EqualityOperator;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.PrimitiveObjects;
import org.apache.taglibs.standard.lang.jstl.RelationalOperator;

public class Coercions {
    public static Object coerce(Object object, Class clazz, Logger logger) throws ELException {
        if (clazz == String.class) {
            return Coercions.coerceToString(object, logger);
        }
        if (Coercions.isPrimitiveNumberClass(clazz)) {
            return Coercions.coerceToPrimitiveNumber(object, clazz, logger);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Coercions.coerceToCharacter(object, logger);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Coercions.coerceToBoolean(object, logger);
        }
        return Coercions.coerceToObject(object, clazz, logger);
    }

    static boolean isPrimitiveNumberClass(Class clazz) {
        return clazz == Byte.class || clazz == Byte.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
    }

    public static String coerceToString(Object object, Logger logger) throws ELException {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.TOSTRING_EXCEPTION, exception, (Object)object.getClass().getName());
            }
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object object, Class clazz, Logger logger) throws ELException {
        if (object == null || "".equals(object)) {
            return Coercions.coerceToPrimitiveNumber(0L, clazz);
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return Coercions.coerceToPrimitiveNumber((short)c, clazz);
        }
        if (object instanceof Boolean) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.BOOLEAN_TO_NUMBER, object, (Object)clazz.getName());
            }
            return Coercions.coerceToPrimitiveNumber(0L, clazz);
        }
        if (object.getClass() == clazz) {
            return (Number)object;
        }
        if (object instanceof Number) {
            return Coercions.coerceToPrimitiveNumber((Number)object, clazz);
        }
        if (object instanceof String) {
            try {
                return Coercions.coerceToPrimitiveNumber((String)object, clazz);
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.STRING_TO_NUMBER_EXCEPTION, (String)object, (Object)clazz.getName());
                }
                return Coercions.coerceToPrimitiveNumber(0L, clazz);
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_NUMBER, object.getClass().getName(), (Object)clazz.getName());
        }
        return Coercions.coerceToPrimitiveNumber(0L, clazz);
    }

    public static Integer coerceToInteger(Object object, Logger logger) throws ELException {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return PrimitiveObjects.getInteger(((Character)object).charValue());
        }
        if (object instanceof Boolean) {
            if (logger.isLoggingWarning()) {
                logger.logWarning(Constants.BOOLEAN_TO_NUMBER, object, (Object)Integer.class.getName());
            }
            return PrimitiveObjects.getInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return PrimitiveObjects.getInteger(((Number)object).intValue());
        }
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (Exception exception) {
                if (logger.isLoggingWarning()) {
                    logger.logWarning(Constants.STRING_TO_NUMBER_EXCEPTION, (String)object, (Object)Integer.class.getName());
                }
                return null;
            }
        }
        if (logger.isLoggingWarning()) {
            logger.logWarning(Constants.COERCE_TO_NUMBER, object.getClass().getName(), (Object)Integer.class.getName());
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long l, Class clazz) throws ELException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)l);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort((short)l);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)l);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong(l);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat(l);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(l);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double d, Class clazz) throws ELException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)d);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort((short)d);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)d);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong((long)d);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat((float)d);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(d);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number number, Class clazz) throws ELException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte(number.byteValue());
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort(number.shortValue());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger(number.intValue());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong(number.longValue());
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat(number.floatValue());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(number.doubleValue());
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String string, Class clazz) throws ELException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Byte.valueOf(string);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return Short.valueOf(string);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.valueOf(string);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.valueOf(string);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(string);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.valueOf(string);
        }
        return PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object object, Logger logger) throws ELException {
        if (object == null || "".equals(object)) {
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Boolean) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.BOOLEAN_TO_CHARACTER, object);
            }
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (object instanceof Number) {
            return PrimitiveObjects.getCharacter((char)((Number)object).shortValue());
        }
        if (object instanceof String) {
            String string = (String)object;
            return PrimitiveObjects.getCharacter(string.charAt(0));
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_CHARACTER, object.getClass().getName());
        }
        return PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object object, Logger logger) throws ELException {
        if (object == null || "".equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Boolean.valueOf(string);
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.STRING_TO_BOOLEAN, exception, (Object)((String)object));
                }
                return Boolean.FALSE;
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_BOOLEAN, object.getClass().getName());
        }
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object object, Class clazz, Logger logger) throws ELException {
        if (object == null) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (object instanceof String) {
            String string = (String)object;
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
            if (propertyEditor == null) {
                if ("".equals(string)) {
                    return null;
                }
                if (logger.isLoggingError()) {
                    logger.logError(Constants.NO_PROPERTY_EDITOR, string, (Object)clazz.getName());
                }
                return null;
            }
            try {
                propertyEditor.setAsText(string);
                return propertyEditor.getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("".equals(string)) {
                    return null;
                }
                if (logger.isLoggingError()) {
                    logger.logError(Constants.PROPERTY_EDITOR_ERROR, illegalArgumentException, object, (Object)clazz.getName());
                }
                return null;
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_OBJECT, object.getClass().getName(), (Object)clazz.getName());
        }
        return null;
    }

    public static Object applyArithmeticOperator(Object object, Object object2, ArithmeticOperator arithmeticOperator, Logger logger) throws ELException {
        if (object == null && object2 == null) {
            if (logger.isLoggingWarning()) {
                logger.logWarning(Constants.ARITH_OP_NULL, arithmeticOperator.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2) || Coercions.isFloatingPointString(object) || Coercions.isFloatingPointString(object2)) {
            double d = Coercions.coerceToPrimitiveNumber(object, Double.class, logger).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class, logger).doubleValue();
            return PrimitiveObjects.getDouble(arithmeticOperator.apply(d, d2, logger));
        }
        long l = Coercions.coerceToPrimitiveNumber(object, Long.class, logger).longValue();
        long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class, logger).longValue();
        return PrimitiveObjects.getLong(arithmeticOperator.apply(l, l2, logger));
    }

    public static Object applyRelationalOperator(Object object, Object object2, RelationalOperator relationalOperator, Logger logger) throws ELException {
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2)) {
            double d = Coercions.coerceToPrimitiveNumber(object, Double.class, logger).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class, logger).doubleValue();
            return PrimitiveObjects.getBoolean(relationalOperator.apply(d, d2, logger));
        }
        if (Coercions.isIntegerType(object) || Coercions.isIntegerType(object2)) {
            long l = Coercions.coerceToPrimitiveNumber(object, Long.class, logger).longValue();
            long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class, logger).longValue();
            return PrimitiveObjects.getBoolean(relationalOperator.apply(l, l2, logger));
        }
        if (object instanceof String || object2 instanceof String) {
            String string = Coercions.coerceToString(object, logger);
            String string2 = Coercions.coerceToString(object2, logger);
            return PrimitiveObjects.getBoolean(relationalOperator.apply(string, string2, logger));
        }
        if (object instanceof Comparable) {
            try {
                int n = ((Comparable)object).compareTo(object2);
                return PrimitiveObjects.getBoolean(relationalOperator.apply(n, -n, logger));
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.COMPARABLE_ERROR, exception, (Object)object.getClass().getName(), (Object)(object2 == null ? "null" : object2.getClass().getName()), (Object)relationalOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (object2 instanceof Comparable) {
            try {
                int n = ((Comparable)object2).compareTo(object);
                return PrimitiveObjects.getBoolean(relationalOperator.apply(-n, n, logger));
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.COMPARABLE_ERROR, exception, (Object)object2.getClass().getName(), (Object)(object == null ? "null" : object.getClass().getName()), (Object)relationalOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.ARITH_OP_BAD_TYPE, relationalOperator.getOperatorSymbol(), (Object)object.getClass().getName(), (Object)object2.getClass().getName());
        }
        return Boolean.FALSE;
    }

    public static Object applyEqualityOperator(Object object, Object object2, EqualityOperator equalityOperator, Logger logger) throws ELException {
        if (object == object2) {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(true, logger));
        }
        if (object == null || object2 == null) {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(false, logger));
        }
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2)) {
            double d;
            double d2 = Coercions.coerceToPrimitiveNumber(object, Double.class, logger).doubleValue();
            return PrimitiveObjects.getBoolean(equalityOperator.apply(d2 == (d = Coercions.coerceToPrimitiveNumber(object2, Double.class, logger).doubleValue()), logger));
        }
        if (Coercions.isIntegerType(object) || Coercions.isIntegerType(object2)) {
            long l;
            long l2 = Coercions.coerceToPrimitiveNumber(object, Long.class, logger).longValue();
            return PrimitiveObjects.getBoolean(equalityOperator.apply(l2 == (l = Coercions.coerceToPrimitiveNumber(object2, Long.class, logger).longValue()), logger));
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = Coercions.coerceToBoolean(object, logger);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(bl2 == (bl = Coercions.coerceToBoolean(object2, logger).booleanValue()), logger));
        }
        if (object instanceof String || object2 instanceof String) {
            String string = Coercions.coerceToString(object, logger);
            String string2 = Coercions.coerceToString(object2, logger);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(string.equals(string2), logger));
        }
        try {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(object.equals(object2), logger));
        }
        catch (Exception exception) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.ERROR_IN_EQUALS, exception, (Object)object.getClass().getName(), (Object)object2.getClass().getName(), (Object)equalityOperator.getOperatorSymbol());
            }
            return Boolean.FALSE;
        }
    }

    public static boolean isFloatingPointType(Object object) {
        return object != null && Coercions.isFloatingPointType(object.getClass());
    }

    public static boolean isFloatingPointType(Class clazz) {
        return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
    }

    public static boolean isFloatingPointString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c != '.' && c != 'e' && c != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object object) {
        return object != null && Coercions.isIntegerType(object.getClass());
    }

    public static boolean isIntegerType(Class clazz) {
        return clazz == Byte.class || clazz == Byte.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Character.class || clazz == Character.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE;
    }
}

