/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import org.apache.taglibs.standard.lang.jstl.BinaryOperator;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.PrimitiveObjects;

public class ModulusOperator
extends BinaryOperator {
    public static final ModulusOperator SINGLETON = new ModulusOperator();

    @Override
    public String getOperatorSymbol() {
        return "%";
    }

    @Override
    public Object apply(Object object, Object object2, Object object3, Logger logger) throws ELException {
        if (object == null && object2 == null) {
            if (logger.isLoggingWarning()) {
                logger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (object != null && (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointString(object)) || object2 != null && (Coercions.isFloatingPointType(object2) || Coercions.isFloatingPointString(object2))) {
            double d = Coercions.coerceToPrimitiveNumber(object, Double.class, logger).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class, logger).doubleValue();
            try {
                return PrimitiveObjects.getDouble(d % d2);
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + d), (Object)("" + d2));
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        long l = Coercions.coerceToPrimitiveNumber(object, Long.class, logger).longValue();
        long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class, logger).longValue();
        try {
            return PrimitiveObjects.getLong(l % l2);
        }
        catch (Exception exception) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + l), (Object)("" + l2));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

