/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ImportSupport;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ParseSupport
extends BodyTagSupport {
    protected Object xml;
    protected String systemId;
    protected XMLFilter filter;
    private String var;
    private String varDom;
    private int scope;
    private int scopeDom;
    private DocumentBuilderFactory dbf;
    private DocumentBuilder db;
    private TransformerFactory tf;
    private TransformerHandler th;

    public ParseSupport() {
        this.init();
    }

    private void init() {
        this.varDom = null;
        this.var = null;
        this.xml = null;
        this.systemId = null;
        this.filter = null;
        this.dbf = null;
        this.db = null;
        this.tf = null;
        this.th = null;
        this.scope = 1;
        this.scopeDom = 1;
    }

    public int doEndTag() throws JspException {
        try {
            Object object;
            Object object2;
            if (this.dbf == null) {
                this.dbf = DocumentBuilderFactory.newInstance();
                this.dbf.setNamespaceAware(true);
                this.dbf.setValidating(false);
            }
            this.db = this.dbf.newDocumentBuilder();
            if (this.filter != null) {
                if (this.tf == null) {
                    this.tf = TransformerFactory.newInstance();
                }
                if (!this.tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                    throw new JspTagException(Resources.getMessage("PARSE_NO_SAXTRANSFORMER"));
                }
                object2 = (SAXTransformerFactory)this.tf;
                this.th = ((SAXTransformerFactory)object2).newTransformerHandler();
            }
            if ((object = this.xml) == null) {
                object = this.bodyContent != null && this.bodyContent.getString() != null ? this.bodyContent.getString().trim() : "";
            }
            if (object instanceof String) {
                object2 = this.parseStringWithFilter((String)object, this.filter);
            } else if (object instanceof Reader) {
                object2 = this.parseReaderWithFilter((Reader)object, this.filter);
            } else {
                throw new JspTagException(Resources.getMessage("PARSE_INVALID_SOURCE"));
            }
            if (this.var != null) {
                this.pageContext.setAttribute(this.var, object2, this.scope);
            }
            if (this.varDom != null) {
                this.pageContext.setAttribute(this.varDom, object2, this.scopeDom);
            }
            return 6;
        }
        catch (SAXException sAXException) {
            throw new JspException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspException((Throwable)parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new JspException((Throwable)transformerConfigurationException);
        }
    }

    public void release() {
        this.init();
    }

    private Document parseInputSourceWithFilter(InputSource inputSource, XMLFilter xMLFilter) throws SAXException, IOException {
        if (xMLFilter != null) {
            Document document = this.db.newDocument();
            this.th.setResult(new DOMResult(document));
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setEntityResolver(new JstlEntityResolver(this.pageContext));
            xMLFilter.setParent(xMLReader);
            xMLFilter.setContentHandler(this.th);
            xMLFilter.parse(inputSource);
            return document;
        }
        return this.parseInputSource(inputSource);
    }

    private Document parseReaderWithFilter(Reader reader, XMLFilter xMLFilter) throws SAXException, IOException {
        return this.parseInputSourceWithFilter(new InputSource(reader), xMLFilter);
    }

    private Document parseStringWithFilter(String string, XMLFilter xMLFilter) throws SAXException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.parseReaderWithFilter(stringReader, xMLFilter);
    }

    private Document parseURLWithFilter(String string, XMLFilter xMLFilter) throws SAXException, IOException {
        return this.parseInputSourceWithFilter(new InputSource(string), xMLFilter);
    }

    private Document parseInputSource(InputSource inputSource) throws SAXException, IOException {
        this.db.setEntityResolver(new JstlEntityResolver(this.pageContext));
        if (this.systemId == null) {
            inputSource.setSystemId("jstl:");
        } else if (ImportSupport.isAbsoluteUrl(this.systemId)) {
            inputSource.setSystemId(this.systemId);
        } else {
            inputSource.setSystemId("jstl:" + this.systemId);
        }
        return this.db.parse(inputSource);
    }

    private Document parseReader(Reader reader) throws SAXException, IOException {
        return this.parseInputSource(new InputSource(reader));
    }

    private Document parseString(String string) throws SAXException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.parseReader(stringReader);
    }

    private Document parseURL(String string) throws SAXException, IOException {
        return this.parseInputSource(new InputSource(string));
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setVarDom(String string) {
        this.varDom = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public void setScopeDom(String string) {
        this.scopeDom = Util.getScope(string);
    }

    public static class JstlEntityResolver
    implements EntityResolver {
        private final PageContext ctx;

        public JstlEntityResolver(PageContext pageContext) {
            this.ctx = pageContext;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws FileNotFoundException {
            InputStream inputStream;
            if (string2 == null) {
                return null;
            }
            if (string2.startsWith("jstl:")) {
                string2 = string2.substring(5);
            }
            if (ImportSupport.isAbsoluteUrl(string2)) {
                return null;
            }
            if (string2.startsWith("/")) {
                inputStream = this.ctx.getServletContext().getResourceAsStream(string2);
                if (inputStream == null) {
                    throw new FileNotFoundException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", string2));
                }
            } else {
                String string3 = ((HttpServletRequest)this.ctx.getRequest()).getServletPath();
                String string4 = string3.substring(0, string3.lastIndexOf("/"));
                inputStream = this.ctx.getServletContext().getResourceAsStream(string4 + "/" + string2);
                if (inputStream == null) {
                    throw new FileNotFoundException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", string2));
                }
            }
            return new InputSource(inputStream);
        }
    }
}

