/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.auth.AppEngineAuthUtils;
import com.google.api.server.spi.auth.AuthUtils;
import com.google.api.server.spi.auth.GoogleIdTokenUtils;
import com.google.api.server.spi.auth.UserContainer;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.Authenticator;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class EndpointsAuthenticator
implements Authenticator {
    private final GoogleIdTokenUtils idTokenUtils;
    private final AppEngineAuthUtils appEngineAuthUtils;
    private final boolean clientIdWhitelistEnabled;

    public EndpointsAuthenticator(boolean clientIdWhitelistEnabled) {
        this.clientIdWhitelistEnabled = clientIdWhitelistEnabled;
        this.idTokenUtils = GoogleIdTokenUtils.getInstance();
        this.appEngineAuthUtils = new AppEngineAuthUtils(clientIdWhitelistEnabled);
    }

    public EndpointsAuthenticator() {
        this(true);
    }

    @VisibleForTesting
    public EndpointsAuthenticator(boolean clientIdWhitelistEnabled, GoogleIdTokenUtils idTokenUtils, AppEngineAuthUtils appEngineAuthUtils) {
        this.clientIdWhitelistEnabled = clientIdWhitelistEnabled;
        this.idTokenUtils = idTokenUtils;
        this.appEngineAuthUtils = appEngineAuthUtils;
    }

    @Override
    public User authenticate(HttpServletRequest request) {
        throw new UnsupportedOperationException("EndpointsAuthenticator requres method configuration.");
    }

    public UserContainer authenticate(HttpServletRequest request, ApiMethodConfig methodConfig) {
        Object user;
        List<String> allowedClientIds = methodConfig.getClientIds();
        if (this.clientIdWhitelistEnabled && (allowedClientIds == null || allowedClientIds.isEmpty())) {
            return null;
        }
        UserContainer userContainer = null;
        String token = AuthUtils.getAuthToken(request);
        if (!AuthUtils.isEmptyOrWhitespace(token)) {
            if (AuthUtils.isIdToken(token)) {
                user = this.idTokenUtils.getCurrentUser(this.clientIdWhitelistEnabled, token, allowedClientIds, methodConfig.getAudiences());
                if (user != null) {
                    userContainer = new UserContainer((User)user);
                }
            } else if (EnvUtil.isRunningOnAppEngine() && (user = this.appEngineAuthUtils.getCurrentUser(token, methodConfig)) != null) {
                userContainer = new UserContainer((com.google.appengine.api.users.User)user);
            }
        }
        if (userContainer == null && this.shouldTryCookieAuth(methodConfig) && EnvUtil.isRunningOnAppEngine() && (user = this.appEngineAuthUtils.getCookieUser()) != null) {
            userContainer = new UserContainer((com.google.appengine.api.users.User)user);
        }
        return userContainer;
    }

    @VisibleForTesting
    boolean shouldTryCookieAuth(ApiMethodConfig methodConfig) {
        return methodConfig.getApiClassConfig().getApiConfig().getAuthConfig().getAllowCookieAuth();
    }
}

