/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.objectweb.asm.util;

import com.google.appengine.repackaged.org.objectweb.asm.AnnotationVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.Attribute;
import com.google.appengine.repackaged.org.objectweb.asm.FieldVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.TypePath;
import com.google.appengine.repackaged.org.objectweb.asm.util.CheckAnnotationAdapter;
import com.google.appengine.repackaged.org.objectweb.asm.util.CheckClassAdapter;
import com.google.appengine.repackaged.org.objectweb.asm.util.CheckMethodAdapter;

public class CheckFieldAdapter
extends FieldVisitor {
    private boolean end;

    public CheckFieldAdapter(FieldVisitor fv) {
        this(327680, fv);
        if (this.getClass() != CheckFieldAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckFieldAdapter(int api, FieldVisitor fv) {
        super(api, fv);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkEnd();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(desc, visible));
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.checkEnd();
        int sort = typeRef >>> 24;
        if (sort != 19) {
            String string = String.valueOf(Integer.toHexString(sort));
            throw new IllegalArgumentException(string.length() != 0 ? "Invalid type reference sort 0x".concat(string) : new String("Invalid type reference sort 0x"));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
    }

    public void visitAttribute(Attribute attr) {
        this.checkEnd();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attr);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        super.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

