/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiConfigException;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;

public abstract class EndpointsToolAction
extends Action {
    private static final int MAX_WIDTH = 80;
    private static final int OPTION_INDENT = 2;
    private static final int OPTION_DESCRIPTION_INDENT = 2;
    public static final String OPTION_CLASS_PATH_SHORT = "cp";
    public static final String OPTION_CLASS_PATH_LONG = "classpath";
    public static final String OPTION_OUTPUT_DIR_SHORT = "o";
    public static final String OPTION_OUTPUT_DIR_LONG = "output";
    public static final String OPTION_WAR_SHORT = "w";
    public static final String OPTION_WAR_LONG = "war";
    public static final String OPTION_LANGUAGE_SHORT = "l";
    public static final String OPTION_LANGUAGE_LONG = "language";
    public static final String OPTION_BUILD_SYSTEM_SHORT = "bs";
    public static final String OPTION_BUILD_SYSTEM_LONG = "build-system";
    public static final String OPTION_FORMAT_SHORT = "f";
    public static final String OPTION_FORMAT_LONG = "format";
    public static final String OPTION_DEBUG = "debug";
    @VisibleForTesting
    static final String DEFAULT_WAR_PATH = "./war";
    @VisibleForTesting
    static final String DEFAULT_OUTPUT_PATH = "./";
    @VisibleForTesting
    static final String DEFAULT_WAR_OUTPUT_PATH_SUFFIX = "WEB-INF";
    @VisibleForTesting
    static final String DEFAULT_CLASS_PATH = "";
    @VisibleForTesting
    static final String DEFAULT_LANGUAGE = "java";
    @VisibleForTesting
    static final String DEFAULT_BUILD_SYSTEM = null;
    @VisibleForTesting
    static final String DEFAULT_FORMAT = "rest";
    private boolean helpDisplayNeeded = true;
    private String exampleString = null;

    public EndpointsToolAction(String name) {
        super(new String[]{name});
    }

    public abstract String getUsageString();

    public abstract boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException;

    public void apply() {
    }

    protected List<String> getHelpLines() {
        ImmutableList.Builder helpLines = ImmutableList.builder();
        helpLines.add((Object)this.getNameString());
        helpLines.add((Object)DEFAULT_CLASS_PATH);
        helpLines.addAll(EndpointsToolAction.wrap(this.getShortDescription(), 80, 0));
        helpLines.add((Object)DEFAULT_CLASS_PATH);
        String string = String.valueOf(this.getUsageString());
        helpLines.add((Object)(string.length() != 0 ? "Usage: <Endpoints tool> ".concat(string) : new String("Usage: <Endpoints tool> ")));
        if (this.getOptions().size() > 0) {
            helpLines.add((Object)DEFAULT_CLASS_PATH);
            helpLines.add((Object)"Options:");
            for (Option option : this.getOptions()) {
                for (String optionHelpLine : option.getHelpLines()) {
                    String string2 = String.valueOf(Strings.repeat((String)" ", (int)2));
                    String string3 = String.valueOf(optionHelpLine);
                    helpLines.add((Object)(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                }
            }
        }
        helpLines.add((Object)DEFAULT_CLASS_PATH);
        if (!Strings.isNullOrEmpty((String)this.exampleString)) {
            helpLines.add((Object)"Example:");
            String string4 = String.valueOf(this.exampleString);
            helpLines.add((Object)(string4.length() != 0 ? "  ".concat(string4) : new String("  ")));
            helpLines.add((Object)DEFAULT_CLASS_PATH);
        }
        return helpLines.build();
    }

    protected String getWarPath(Option warOption) {
        return this.getOptionOrDefault(warOption, DEFAULT_WAR_PATH);
    }

    protected String getOutputPath(Option outputOption) {
        return this.getOptionOrDefault(outputOption, DEFAULT_OUTPUT_PATH);
    }

    protected String getWarOutputPath(Option outputOption, String warPath) {
        if (outputOption.getValue() != null) {
            return outputOption.getValue();
        }
        String string = String.valueOf(File.separator);
        String string2 = String.valueOf(DEFAULT_WAR_OUTPUT_PATH_SUFFIX);
        return new StringBuilder(0 + String.valueOf(warPath).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(warPath).append(string).append(string2).toString();
    }

    protected String getClassPath(Option classPathOption) {
        return this.getOptionOrDefault(classPathOption, DEFAULT_CLASS_PATH);
    }

    protected String getLanguage(Option languageOption) {
        return this.getOptionOrDefault(languageOption, DEFAULT_LANGUAGE);
    }

    protected String getBuildSystem(Option buildSystemOption) {
        return this.getOptionOrDefault(buildSystemOption, DEFAULT_BUILD_SYSTEM);
    }

    protected String getFormat(Option formatOption) {
        return this.getOptionOrDefault(formatOption, DEFAULT_FORMAT);
    }

    protected boolean getDebug(Option debugOption) {
        return debugOption.getValue() != null;
    }

    protected String getOptionOrDefault(Option option, String defaultValue) {
        if (option.getValue() != null) {
            return option.getValue();
        }
        return defaultValue;
    }

    protected Option makeWarOption() {
        return EndpointsOption.makeVisibleNonFlagOption(OPTION_WAR_SHORT, OPTION_WAR_LONG, "WAR_PATH", "Sets the path to the war directory where web-appengine.xml and other metadata are located. Default: ./war.");
    }

    protected Option makeOutputOption() {
        return EndpointsOption.makeVisibleNonFlagOption(OPTION_OUTPUT_DIR_SHORT, OPTION_OUTPUT_DIR_LONG, "OUTPUT_DIR", "Sets the directory where the output will be written to. Default: the directory the tool is invoked from.");
    }

    protected Option makeWarOutputOption() {
        return EndpointsOption.makeVisibleNonFlagOption(OPTION_OUTPUT_DIR_SHORT, OPTION_OUTPUT_DIR_LONG, "OUTPUT_DIR", "Sets the directory where the output will be written to. Default: the directory the tool is invoked from.");
    }

    protected Option makeClassPathOption() {
        return EndpointsOption.makeVisibleNonFlagOption(OPTION_CLASS_PATH_SHORT, OPTION_CLASS_PATH_LONG, "CLASSPATH", "Lets you specify the service class or classes from a path other than the default <war-directory>/WEB-INF/libs and <war-directory>/WEB-INF/classes, where <war-directory is the directory specified in the war option, or simply ./war if that option is not supplied.");
    }

    protected Option makeLanguageOption() {
        return EndpointsOption.makeVisibleNonFlagOption(OPTION_LANGUAGE_SHORT, OPTION_LANGUAGE_LONG, "LANGUAGE", "Sets the target output programming language. Default: java.");
    }

    protected Option makeBuildSystemOption() {
        return EndpointsOption.makeVisibleNonFlagOption(OPTION_BUILD_SYSTEM_SHORT, OPTION_BUILD_SYSTEM_LONG, "BUILD_SYSTEM", "Sets the build type for the generated client bundle. Possible values: default, maven and gradle. Default: default.");
    }

    protected Option makeFormatOption() {
        return EndpointsOption.makeVisibleNonFlagOption(OPTION_FORMAT_SHORT, OPTION_FORMAT_LONG, "FORMAT", "Sets the format of the generated discovery document. Possible values: rest or rpc. Default is rest.");
    }

    protected Option makeDebugOption() {
        return EndpointsOption.makeInvisibleFlagOption(null, OPTION_DEBUG);
    }

    protected URL[] computeClassPath(String warPath, String classPath) throws MalformedURLException {
        ImmutableList.Builder urls = ImmutableList.builder();
        File warDir = new File(warPath).getAbsoluteFile();
        File webInfDir = new File(warDir, DEFAULT_WAR_OUTPUT_PATH_SUFFIX);
        File classesDir = new File(webInfDir, "classes");
        urls.add((Object)classesDir.toURI().toURL());
        File libDir = new File(webInfDir, "lib");
        String[] files = libDir.list();
        if (files != null) {
            for (String file : files) {
                File maybeJar = new File(libDir, file);
                if (!maybeJar.isFile() || !file.endsWith(".jar")) continue;
                urls.add((Object)maybeJar.toURI().toURL());
            }
        }
        if (!Strings.isNullOrEmpty((String)classPath)) {
            for (String classPathEntry : classPath.split(File.pathSeparator)) {
                urls.add((Object)new File(classPathEntry).toURI().toURL());
            }
        }
        return (URL[])urls.build().toArray((Object[])new URL[0]);
    }

    public boolean isHelpDisplayNeeded() {
        return this.helpDisplayNeeded;
    }

    public void setHelpDisplayNeeded(boolean helpDisplayNeeded) {
        this.helpDisplayNeeded = helpDisplayNeeded;
    }

    public String getExampleString() {
        return this.exampleString;
    }

    public void setExampleString(String exampleString) {
        this.exampleString = exampleString;
    }

    @VisibleForTesting
    static List<String> wrap(String source, int maxWidth, int indent) {
        Iterable words = Splitter.on((String)" ").split((CharSequence)source);
        ImmutableList.Builder wrappedLines = ImmutableList.builder();
        StringBuffer line = new StringBuffer(Strings.repeat((String)" ", (int)indent));
        int lineLength = indent;
        for (String word : words) {
            if (lineLength + word.length() >= maxWidth) {
                wrappedLines.add((Object)line.toString());
                line = new StringBuffer(Strings.repeat((String)" ", (int)indent));
                lineLength = indent;
            }
            if (lineLength > indent && lineLength < maxWidth) {
                line.append(" ");
                ++lineLength;
            }
            line.append(word);
            lineLength += word.length();
        }
        wrappedLines.add((Object)line.toString());
        return wrappedLines.build();
    }

    @VisibleForTesting
    protected static class EndpointsOption
    extends Option {
        private String description;
        private String placeHolderValue;
        private boolean isVisible;

        private EndpointsOption(@Nullable String shortName, @Nullable String longName, boolean isFlag, boolean isVisible, @Nullable String placeHolderValue, @Nullable String description) {
            super(shortName, longName, isFlag);
            Preconditions.checkArgument((isFlag || !isVisible || placeHolderValue != null ? 1 : 0) != 0, (Object)"non-null placeholder value required");
            Preconditions.checkArgument((!isVisible || description != null ? 1 : 0) != 0, (Object)"non-null description required");
            this.description = description;
            this.placeHolderValue = placeHolderValue;
            this.isVisible = isVisible;
        }

        public static EndpointsOption makeVisibleNonFlagOption(@Nullable String shortName, @Nullable String longName, @Nullable String placeHolderValue, @Nullable String description) {
            return new EndpointsOption(shortName, longName, false, true, placeHolderValue, description);
        }

        public static EndpointsOption makeInvisibleFlagOption(@Nullable String shortName, @Nullable String longName) {
            return new EndpointsOption(shortName, longName, true, false, null, null){

                @Override
                public void apply() {
                    this.getValues().add("true");
                }
            };
        }

        public void apply() {
        }

        public Optional<String> getShortForm(boolean includePlaceholder) {
            if (this.getShortName() == null) {
                return Optional.absent();
            }
            StringBuffer form = new StringBuffer();
            String string = String.valueOf(this.getShortName());
            form.append(string.length() != 0 ? "-".concat(string) : new String("-"));
            if (!this.isFlag() && includePlaceholder) {
                String string2 = String.valueOf(this.placeHolderValue);
                form.append(string2.length() != 0 ? " ".concat(string2) : new String(" "));
            }
            return Optional.of((Object)form.toString());
        }

        public Optional<String> getLongForm(boolean includePlaceholder) {
            if (this.getLongName() == null) {
                return Optional.absent();
            }
            StringBuffer form = new StringBuffer();
            String string = String.valueOf(this.getLongName());
            form.append(string.length() != 0 ? "--".concat(string) : new String("--"));
            if (!this.isFlag() && includePlaceholder) {
                String string2 = String.valueOf(this.placeHolderValue);
                form.append(string2.length() != 0 ? "=".concat(string2) : new String("="));
            }
            return Optional.of((Object)form.toString());
        }

        public List<String> getHelpLines() {
            if (!this.isVisible) {
                return super.getHelpLines();
            }
            Optional<String> shortForm = this.getShortForm(true);
            Optional<String> longForm = this.getLongForm(true);
            StringBuffer option = new StringBuffer();
            if (shortForm.isPresent()) {
                option.append((String)shortForm.get());
                if (longForm.isPresent()) {
                    option.append(", ");
                }
            }
            if (longForm.isPresent()) {
                option.append((String)longForm.get());
            }
            ImmutableList.Builder lines = ImmutableList.builder();
            lines.add((Object)option.toString());
            lines.addAll(EndpointsToolAction.wrap(this.description, 78, 2));
            return lines.build();
        }
    }
}

