/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.EnvUtil;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;

public class DevApiUtil {
    public static final String ENV_VAR_FOR_ENDPOINTS_PORT = "ENDPOINTS_PORT";
    @VisibleForTesting
    static final int DEFAULT_ENDPOINTS_PORT = 8080;

    public static String stripLeadingSlash(String s) {
        return s == null ? null : (s.charAt(0) == '/' ? s.substring(1) : s);
    }

    public static String stripTrailingSlash(String s) {
        return s == null ? null : (s.endsWith("/") ? s.substring(0, s.length() - 1) : s);
    }

    public static String getMethodKey(String pathOrHttpMethod, String name, String version) {
        return new StringBuilder(2 + String.valueOf(pathOrHttpMethod).length() + String.valueOf(name).length() + String.valueOf(version).length()).append(pathOrHttpMethod).append(":").append(name).append(":").append(version).toString();
    }

    public static String getConfigEndpoint() {
        if (EnvUtil.isRunningOnAppEngine()) {
            return "/_ah/spi/";
        }
        return "/";
    }

    public static int getBackendPort() {
        if (System.getenv(ENV_VAR_FOR_ENDPOINTS_PORT) == null) {
            return 8080;
        }
        return Integer.parseInt(System.getenv(ENV_VAR_FOR_ENDPOINTS_PORT));
    }
}

