/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.tools.JacksonUtil;
import com.google.api.server.spi.tools.devserver.ApiConfig;
import com.google.api.server.spi.tools.devserver.ApiServlet;
import com.google.api.server.spi.tools.devserver.DevApiUtil;
import com.google.api.server.spi.tools.devserver.Headers;
import com.google.api.server.spi.tools.devserver.LilyClient;
import com.google.api.server.spi.tools.devserver.PathTrie;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestApiServlet
extends ApiServlet {
    private static final Logger logger = Logger.getLogger(RestApiServlet.class.getName());
    private static final String EXPLORER_PATH = "explorer";
    private static final String EXPLORER_URL = "http://apis-explorer.appspot.com/apis-explorer/";
    private PathTrie pathTrie;

    @Override
    protected LilyClient.Request marshallRequest(HttpServletRequest request, ApiConfig.Method method, ObjectNode params) throws IOException {
        return LilyRequestMarshaller.marshall(request, method, params);
    }

    @Override
    protected void loadApiConfigs(List<ApiConfig> apiConfigs) {
        this.pathTrie = new PathTrie(apiConfigs);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.initConfigsIfNecessary(request);
        String path = request.getRequestURI().substring(request.getServletPath().length());
        String requestPath = DevApiUtil.stripLeadingSlash(path);
        if (this.handleExplorer(requestPath, request, response)) {
            return;
        }
        ObjectNode userParams = mapper.createObjectNode();
        ApiConfig.Method method = this.pathTrie.get(request.getMethod().toLowerCase(), path, userParams);
        if (method == null) {
            response.sendError(404);
        } else {
            LilyResponseMarshaller.marshall(this.doSingleBackendCall(request, method, userParams), response);
        }
    }

    @Override
    protected void addParametersToMap(HttpServletRequest request, ApiConfig.Method method, ObjectNode params) {
        this.addQueryParams((ServletRequest)request, method.request.parameters, params);
        super.addParametersToMap(request, method, params);
    }

    private boolean handleExplorer(String requestPath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ((requestPath = DevApiUtil.stripTrailingSlash(requestPath)).equalsIgnoreCase(EXPLORER_PATH)) {
            StringBuffer requestUrl = request.getRequestURL();
            String baseUrl = requestUrl.substring(0, requestUrl.lastIndexOf(EXPLORER_PATH) - 1);
            String string = String.valueOf("http://apis-explorer.appspot.com/apis-explorer/?base=");
            String string2 = String.valueOf(baseUrl);
            String redirectUrl = string2.length() != 0 ? string.concat(string2) : new String(string);
            response.sendRedirect(redirectUrl);
            return true;
        }
        return false;
    }

    private void addQueryParams(ServletRequest request, Map<String, ApiConfig.Method.Request.Parameter> methodParameters, ObjectNode parameterMap) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.trim().isEmpty()) continue;
            if (parameterMap.has(name)) {
                throw new IllegalArgumentException(String.format("Both path and query string contained parameter of key '%s'", name));
            }
            ApiConfig.Method.Request.Parameter parameter = methodParameters.get(name);
            if (parameter != null && Boolean.TRUE.equals(parameter.repeated)) {
                parameterMap.put(name, (JsonNode)mapper.convertValue((Object)request.getParameterValues(name), ArrayNode.class));
                continue;
            }
            parameterMap.put(name, request.getParameter(name));
        }
    }

    protected void sendJsonError(Exception e, HttpServletResponse response) throws IOException {
        String string = String.valueOf(e.getMessage());
        response.sendError(400, string.length() != 0 ? "Failed to parse JSON request: ".concat(string) : new String("Failed to parse JSON request: "));
    }

    public static class LilyResponseMarshaller {
        private static void marshall(LilyClient.Response lilyResponse, HttpServletResponse response) throws JsonParseException, JsonMappingException, IOException {
            ApiServlet.convertFromLilyResponse(lilyResponse, response, false, null);
        }
    }

    public static class LilyRequestMarshaller {
        private static LilyClient.Request marshall(HttpServletRequest request, ApiConfig.Method method, ObjectNode params) throws JsonParseException, JsonMappingException, IOException, MalformedURLException {
            ObjectNode body = LilyRequestMarshaller.createBackendRequestBody(request, params);
            Headers headers = ApiServlet.convertHeaders(request);
            return new LilyClient.Request(ApiServlet.getSpiEndpoint(ApiServlet.getHostPort(request), method), headers, body.toString());
        }

        static ObjectNode createBackendRequestBody(HttpServletRequest request, ObjectNode params) throws JsonParseException, JsonMappingException, IOException {
            ObjectNode body = null;
            if (LilyRequestMarshaller.hasBody(request)) {
                String bodyString = IoUtil.readStream((InputStream)ApiServlet.getBodyInputStream(request));
                logger.log(Level.FINE, "requestBody={0}", bodyString);
                if (bodyString != null && !bodyString.trim().isEmpty()) {
                    body = (ObjectNode)ApiServlet.mapper.readValue(bodyString, ObjectNode.class);
                    return JacksonUtil.mergeObject(body, params);
                }
            }
            return params;
        }

        private static boolean hasBody(HttpServletRequest request) {
            String method = request.getMethod();
            return method.equalsIgnoreCase("post") || method.equalsIgnoreCase("put");
        }
    }
}

