/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class Utils {
    private Utils() {
    }

    public static <T> ArrayList<T> newArrayList(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        return new LinkedList<T>(Arrays.asList(elements));
    }

    public static <T> HashSet<T> newHashSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static <T> HashSet<T> newHashSet(Collection<T> elements) {
        return new HashSet<T>(elements);
    }

    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        return new TreeSet<T>(Arrays.asList(elements));
    }

    public static <F, T> List<T> transform(Iterable<F> from, Function<? super F, ? extends T> func) {
        ArrayList<T> to = new ArrayList<T>();
        for (F fromElement : from) {
            to.add(func.apply(fromElement));
        }
        return to;
    }

    public static <T> Function<T, T> identity() {
        return new Function<T, T>(){

            @Override
            public T apply(T from) {
                return from;
            }
        };
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    public static interface Supplier<T> {
        public T get();
    }

    public static interface Function<F, T> {
        public T apply(F var1);
    }
}

