/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.OAuth2Utils;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Beta;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Locale;

@Beta
class DefaultCredentialProvider {
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    static final String WELL_KNOWN_CREDENTIALS_FILE = "application_default_credentials.json";
    static final String CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
    static final String HELP_PERMALINK = "https://developers.google.com/accounts/docs/application-default-credentials";
    static final String APP_ENGINE_CREDENTIAL_CLASS = "com.google.api.client.googleapis.extensions.appengine.auth.oauth2.AppIdentityCredential$AppEngineCredentialWrapper";
    private GoogleCredential cachedCredential = null;
    private boolean checkedAppEngine = false;
    private boolean checkedComputeEngine = false;

    DefaultCredentialProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GoogleCredential getDefaultCredential(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        DefaultCredentialProvider defaultCredentialProvider = this;
        synchronized (defaultCredentialProvider) {
            if (this.cachedCredential == null) {
                this.cachedCredential = this.getDefaultCredentialUnsynchronized(transport, jsonFactory);
            }
            if (this.cachedCredential != null) {
                return this.cachedCredential;
            }
        }
        throw new IOException(String.format("The Application Default Credentials are not available. They are available if running in Google Compute Engine. Otherwise, the environment variable %s must be defined pointing to a file defining the credentials. See %s for more information.", CREDENTIAL_ENV_VAR, HELP_PERMALINK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GoogleCredential getDefaultCredentialUnsynchronized(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        GoogleCredential credential;
        block21: {
            credential = null;
            String credentialsPath = this.getEnv(CREDENTIAL_ENV_VAR);
            if (credentialsPath != null && credentialsPath.length() > 0) {
                try (InputStream credentialsStream = null;){
                    File credentialsFile = new File(credentialsPath);
                    if (!credentialsFile.exists() || credentialsFile.isDirectory()) {
                        throw new IOException("File does not exist.");
                    }
                    credentialsStream = new FileInputStream(credentialsFile);
                    credential = GoogleCredential.fromStream(credentialsStream, transport, jsonFactory);
                }
            }
            if (credential == null) {
                File wellKnownFileLocation = this.getWellKnownCredentialsFile();
                try {
                    if (!this.fileExists(wellKnownFileLocation)) break block21;
                    try (FileInputStream credentialsStream = null;){
                        credentialsStream = new FileInputStream(wellKnownFileLocation);
                        credential = GoogleCredential.fromStream(credentialsStream, transport, jsonFactory);
                    }
                }
                catch (AccessControlException expected) {
                    // empty catch block
                }
            }
        }
        if (credential == null) {
            credential = this.tryGetAppEngineCredential(transport, jsonFactory);
        }
        if (credential == null) {
            credential = this.tryGetComputeCredential(transport, jsonFactory);
        }
        return credential;
    }

    private final File getWellKnownCredentialsFile() {
        File cloudConfigPath = null;
        String os = this.getProperty("os.name", "").toLowerCase(Locale.US);
        if (os.indexOf("windows") >= 0) {
            File appDataPath = new File(this.getEnv("APPDATA"));
            cloudConfigPath = new File(appDataPath, CLOUDSDK_CONFIG_DIRECTORY);
        } else {
            File configPath = new File(this.getProperty("user.home", ""), ".config");
            cloudConfigPath = new File(configPath, CLOUDSDK_CONFIG_DIRECTORY);
        }
        File credentialFilePath = new File(cloudConfigPath, WELL_KNOWN_CREDENTIALS_FILE);
        return credentialFilePath;
    }

    String getEnv(String name) {
        return System.getenv(name);
    }

    boolean fileExists(File file) {
        return file.exists() && !file.isDirectory();
    }

    String getProperty(String property, String def) {
        return System.getProperty(property, def);
    }

    Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    private boolean runningOnAppEngine() {
        Class<?> systemPropertyClass = null;
        try {
            systemPropertyClass = this.forName("com.google.appengine.api.utils.SystemProperty");
        }
        catch (ClassNotFoundException expected) {
            return false;
        }
        Exception cause = null;
        try {
            Field environmentField = systemPropertyClass.getField("environment");
            Object environmentValue = environmentField.get(null);
            Class<?> environmentType = environmentField.getType();
            Method valueMethod = environmentType.getMethod("value", new Class[0]);
            Object environmentValueValue = valueMethod.invoke(environmentValue, new Object[0]);
            return environmentValueValue != null;
        }
        catch (NoSuchFieldException exception) {
            cause = exception;
        }
        catch (SecurityException exception) {
            cause = exception;
        }
        catch (IllegalArgumentException exception) {
            cause = exception;
        }
        catch (IllegalAccessException exception) {
            cause = exception;
        }
        catch (NoSuchMethodException exception) {
            cause = exception;
        }
        catch (InvocationTargetException exception) {
            cause = exception;
        }
        throw OAuth2Utils.exceptionWithCause(new RuntimeException(String.format("Unexpcted error trying to determine if runnning on Google App Engine: %s", cause.getMessage())), cause);
    }

    private final GoogleCredential tryGetAppEngineCredential(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        if (this.checkedAppEngine) {
            return null;
        }
        boolean onAppEngine = this.runningOnAppEngine();
        this.checkedAppEngine = true;
        if (!onAppEngine) {
            return null;
        }
        ReflectiveOperationException innerException = null;
        try {
            Class<?> credentialClass = this.forName(APP_ENGINE_CREDENTIAL_CLASS);
            Constructor<?> constructor = credentialClass.getConstructor(HttpTransport.class, JsonFactory.class);
            return (GoogleCredential)constructor.newInstance(transport, jsonFactory);
        }
        catch (ClassNotFoundException e) {
            innerException = e;
        }
        catch (NoSuchMethodException e) {
            innerException = e;
        }
        catch (InstantiationException e) {
            innerException = e;
        }
        catch (IllegalAccessException e) {
            innerException = e;
        }
        catch (InvocationTargetException e) {
            innerException = e;
        }
        throw OAuth2Utils.exceptionWithCause(new IOException(String.format("Application Default Credentials failed to create the Google App Engine service account credentials class %s. Check that the component 'google-api-client-appengine' is deployed.", APP_ENGINE_CREDENTIAL_CLASS)), innerException);
    }

    private final GoogleCredential tryGetComputeCredential(HttpTransport transport, JsonFactory jsonFactory) {
        if (this.checkedComputeEngine) {
            return null;
        }
        boolean runningOnComputeEngine = OAuth2Utils.runningOnComputeEngine(transport);
        this.checkedComputeEngine = true;
        if (runningOnComputeEngine) {
            return new ComputeGoogleCredential(transport, jsonFactory);
        }
        return null;
    }

    private static class ComputeGoogleCredential
    extends GoogleCredential {
        private static final String TOKEN_SERVER_ENCODED_URL = "http://metadata/computeMetadata/v1/instance/service-accounts/default/token";

        ComputeGoogleCredential(HttpTransport transport, JsonFactory jsonFactory) {
            super(new GoogleCredential.Builder().setTransport(transport).setJsonFactory(jsonFactory).setTokenServerEncodedUrl(TOKEN_SERVER_ENCODED_URL));
        }

        @Override
        protected TokenResponse executeRefreshToken() throws IOException {
            GenericUrl tokenUrl = new GenericUrl(this.getTokenServerEncodedUrl());
            HttpRequest request = this.getTransport().createRequestFactory().buildGetRequest(tokenUrl);
            JsonObjectParser parser = new JsonObjectParser(this.getJsonFactory());
            request.setParser(parser);
            request.getHeaders().set("X-Google-Metadata-Request", true);
            request.setThrowExceptionOnExecuteError(false);
            HttpResponse response = request.execute();
            int statusCode = response.getStatusCode();
            if (statusCode == 200) {
                InputStream content = response.getContent();
                if (content == null) {
                    throw new IOException("Empty content from metadata token server request.");
                }
                return parser.parseAndClose(content, response.getContentCharset(), TokenResponse.class);
            }
            if (statusCode == 404) {
                throw new IOException(String.format("Error code %s trying to get security access token from Compute Engine metadata for the default service account. This may be because the virtual machine instance does not have permission scopes specified.", statusCode));
            }
            throw new IOException(String.format("Unexpected Error code %s trying to get security access token from Compute Engine metadata for the default service account: %s", statusCode, response.parseAsString()));
        }
    }
}

