/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Collection;

public class GoogleAuthorizationCodeTokenRequest
extends AuthorizationCodeTokenRequest {
    public GoogleAuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String clientId, String clientSecret, String code, String redirectUri) {
        this(transport, jsonFactory, "https://accounts.google.com/o/oauth2/token", clientId, clientSecret, code, redirectUri);
    }

    public GoogleAuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String tokenServerEncodedUrl, String clientId, String clientSecret, String code, String redirectUri) {
        super(transport, jsonFactory, new GenericUrl(tokenServerEncodedUrl), code);
        this.setClientAuthentication(new ClientParametersAuthentication(clientId, clientSecret));
        this.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setRequestInitializer(HttpRequestInitializer requestInitializer) {
        return (GoogleAuthorizationCodeTokenRequest)super.setRequestInitializer(requestInitializer);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setTokenServerUrl(GenericUrl tokenServerUrl) {
        return (GoogleAuthorizationCodeTokenRequest)super.setTokenServerUrl(tokenServerUrl);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setScopes(Collection<String> scopes) {
        return (GoogleAuthorizationCodeTokenRequest)super.setScopes((Collection)scopes);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setGrantType(String grantType) {
        return (GoogleAuthorizationCodeTokenRequest)super.setGrantType(grantType);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
        Preconditions.checkNotNull(clientAuthentication);
        return (GoogleAuthorizationCodeTokenRequest)super.setClientAuthentication(clientAuthentication);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setCode(String code) {
        return (GoogleAuthorizationCodeTokenRequest)super.setCode(code);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setRedirectUri(String redirectUri) {
        Preconditions.checkNotNull(redirectUri);
        return (GoogleAuthorizationCodeTokenRequest)super.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleTokenResponse execute() throws IOException {
        return this.executeUnparsed().parseAs(GoogleTokenResponse.class);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest set(String fieldName, Object value) {
        return (GoogleAuthorizationCodeTokenRequest)super.set(fieldName, value);
    }
}

