/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

@Beta
@GwtCompatible
public final class Utf8 {
    public static int encodedLength(CharSequence sequence) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            long l = (long)utf8Length + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                int n = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n).toString());
            }
            ++i;
        }
        return utf8Length;
    }

    @GwtIncompatible(value="ByteBuffer")
    @GoogleInternal
    public static void encode(CharSequence sequence, ByteBuffer buffer) {
        if (buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (buffer.hasArray()) {
            try {
                int encoded = Utf8.encode(sequence, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                buffer.position(encoded - buffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                BufferOverflowException boe = new BufferOverflowException();
                boe.initCause(e);
                throw boe;
            }
        } else {
            Utf8.encodeDirect(sequence, buffer);
        }
    }

    @GwtIncompatible(value="ByteBuffer")
    @GoogleInternal
    private static void encodeDirect(CharSequence sequence, ByteBuffer buffer) {
        int utf16Length = sequence.length();
        for (int i = 0; i < utf16Length; ++i) {
            char low;
            char c = sequence.charAt(i);
            if (c < '\u0080') {
                buffer.put((byte)c);
                continue;
            }
            if (c < '\u0800') {
                buffer.put((byte)(0x3C0 | c >>> 6));
                buffer.put((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                buffer.put((byte)(0x1E0 | c >>> 12));
                buffer.put((byte)(0x80 | 0x3F & c >>> 6));
                buffer.put((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                int n = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n).toString());
            }
            int codePoint = Character.toCodePoint(c, low);
            buffer.put((byte)(0xF0 | codePoint >>> 18));
            buffer.put((byte)(0x80 | 0x3F & codePoint >>> 12));
            buffer.put((byte)(0x80 | 0x3F & codePoint >>> 6));
            buffer.put((byte)(0x80 | 0x3F & codePoint));
        }
    }

    @GoogleInternal
    public static int encode(CharSequence sequence, byte[] bytes) {
        return Utf8.encode(sequence, bytes, 0, bytes.length);
    }

    @GoogleInternal
    public static int encode(CharSequence sequence, byte[] bytes, int offset) {
        return Utf8.encode(sequence, bytes, offset, bytes.length);
    }

    @GoogleInternal
    private static int encode(CharSequence sequence, byte[] bytes, int offset, int length) {
        char c;
        int i;
        int utf16Length = sequence.length();
        int j = offset;
        int limit = offset + length;
        for (i = 0; i < utf16Length && i + j < limit && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            bytes[j + i] = (byte)c;
        }
        if (i == utf16Length) {
            return j + utf16Length;
        }
        j += i;
        while (i < utf16Length) {
            int n;
            c = sequence.charAt(i);
            if (c < '\u0080' && j < limit) {
                bytes[j++] = (byte)c;
            } else if (c < '\u0800' && j <= limit - 2) {
                bytes[j++] = (byte)(0x3C0 | c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                bytes[j++] = (byte)(0x1E0 | c >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if (j <= limit - 4) {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    n = i - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n).toString());
                }
                int codePoint = Character.toCodePoint(c, low);
                bytes[j++] = (byte)(0xF0 | codePoint >>> 18);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint);
            } else {
                char c2 = c;
                n = j;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n).toString());
            }
            ++i;
        }
        return j;
    }

    public static boolean isWellFormed(byte[] bytes) {
        return Utf8.isWellFormed(bytes, 0, bytes.length);
    }

    public static boolean isWellFormed(byte[] bytes, int off, int len) {
        int end = off + len;
        Preconditions.checkPositionIndexes(off, end, bytes.length);
        for (int i = off; i < end; ++i) {
            if (bytes[i] >= 0) continue;
            return Utf8.isWellFormedSlowPath(bytes, i, end);
        }
        return true;
    }

    private static boolean isWellFormedSlowPath(byte[] bytes, int off, int end) {
        int index = off;
        while (true) {
            byte byte2;
            byte byte1;
            if (index >= end) {
                return true;
            }
            if ((byte1 = bytes[index++]) >= 0) continue;
            if (byte1 < -32) {
                if (index == end) {
                    return false;
                }
                if (byte1 >= -62 && bytes[index++] <= -65) continue;
                return false;
            }
            if (byte1 < -16) {
                if (index + 1 >= end) {
                    return false;
                }
                if (!((byte2 = bytes[index++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && -96 <= byte2) && bytes[index++] <= -65) continue;
                return false;
            }
            if (index + 2 >= end) {
                return false;
            }
            if ((byte2 = bytes[index++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes[index++] > -65 || bytes[index++] > -65) break;
        }
        return false;
    }

    private Utf8() {
    }
}

