/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.reflect;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.labs.reflect.ValueType;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Exclude
public final class Value
implements Serializable {
    private static final long serialVersionUID = -6245485085636456222L;
    private final Object target;
    private transient int hash;
    private static final Field[] NO_FIELDS = new Field[0];
    private static final Ordering<Member> BY_NAME = Ordering.natural().onResultOf(new Function<Member, String>(){

        @Override
        public String apply(Member member) {
            return member.getName();
        }
    });
    private static final LoadingCache<Class<?>, Field[]> FIELDS_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<Class<?>, Field[]>(){

        @Override
        public Field[] load(Class<?> key) {
            if (key.isAnnotationPresent(Exclude.class)) {
                return NO_FIELDS;
            }
            ArrayList list = Lists.newArrayList();
            Class<?> superclass = key.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                Collections.addAll(list, (Object[])FIELDS_CACHE.getUnchecked(superclass));
            }
            Value.findDeclaredIncludedFields(key, list);
            AccessibleObject[] fields = list.toArray(new Field[list.size()]);
            Arrays.sort(fields, BY_NAME);
            AccessibleObject.setAccessible(fields, true);
            return fields;
        }
    });
    private volatile transient Object[] fieldValues;
    private transient Object fieldsRef;

    public Value(Object target) {
        Preconditions.checkNotNull(target);
        this.target = target;
    }

    public static Value of(Object target) {
        if (target instanceof ValueType) {
            return ((ValueType)target).value();
        }
        return new Value(target);
    }

    public static int valueHashCode(Object obj) {
        return obj == null ? 0 : Value.of(obj).hashCode();
    }

    public static String valueToString(Object obj) {
        return obj == null ? String.valueOf(null) : Value.of(obj).toString();
    }

    public static boolean valueEquals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return Value.of(left).equals(Value.of(right));
    }

    public int hashCode() {
        int hc = this.hash;
        return hc == 0 ? (this.hash = Value.avoidZero(Arrays.deepHashCode(this.fieldValues()))) : hc;
    }

    @VisibleForTesting
    static int avoidZero(int code) {
        return code == 0 ? Integer.MIN_VALUE : code;
    }

    public boolean equals(Value that) {
        if (this == that) {
            return true;
        }
        if (this.target.getClass() != that.target.getClass()) {
            return false;
        }
        return Arrays.deepEquals(this.fieldValues(), that.fieldValues());
    }

    @Deprecated
    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            return this.equals((Value)obj);
        }
        return false;
    }

    public String toString() {
        Class<?> type = this.target.getClass();
        final Field[] fields = FIELDS_CACHE.getUnchecked(type);
        final Object[] values = this.fieldValues();
        return Value.membersToString(type, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int i) {
                return Value.fieldToString(fields[i], values[i]);
            }

            @Override
            public int size() {
                return fields.length;
            }
        });
    }

    public String toStringHidingNulls() {
        Class<?> type = this.target.getClass();
        Field[] fields = FIELDS_CACHE.getUnchecked(type);
        Object[] values = this.fieldValues();
        ArrayList<String> strings = Lists.newArrayListWithExpectedSize(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            strings.add(Value.fieldToString(fields[i], value));
        }
        return Value.membersToString(type, strings);
    }

    private static String membersToString(Class<?> type, List<String> members) {
        StringBuilder builder = new StringBuilder(type.getSimpleName());
        builder.append('{');
        Joiner.on(", ").appendTo(builder, (Iterable<?>)members);
        builder.append('}');
        return builder.toString();
    }

    private static String fieldToString(Field field, Object value) {
        String s = Arrays.deepToString(new Object[]{value});
        String string = String.valueOf(field.getName());
        String string2 = String.valueOf(s.substring(1, s.length() - 1));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] fieldValues() {
        Object[] values = this.fieldValues;
        if (values == null) {
            Value value = this;
            synchronized (value) {
                Object[] objectArray;
                values = this.fieldValues;
                if (values == null) {
                    this.fieldValues = this.readFieldValues(this.target);
                    objectArray = this.fieldValues;
                } else {
                    objectArray = values;
                }
                return objectArray;
            }
        }
        return values;
    }

    private static void findDeclaredIncludedFields(Class<?> cls, List<Field> list) {
        Field[] flds = cls.getDeclaredFields();
        boolean includeByDefault = cls.getAnnotation(Include.class) != null;
        for (Field fld : flds) {
            if (fld.getAnnotation(Exclude.class) != null || fld.getType().getAnnotation(Exclude.class) != null || fld.getAnnotation(Include.class) == null && (!includeByDefault || !Value.isFinalInstanceField(fld))) continue;
            list.add(fld);
        }
    }

    private static boolean isFinalInstanceField(Field fld) {
        int modifiers = fld.getModifiers();
        return Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers);
    }

    private Object[] readFieldValues(Object obj) {
        Field[] fields;
        this.fieldsRef = fields = FIELDS_CACHE.getUnchecked(obj.getClass());
        Object[] result = new Object[fields.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = fields[i].get(obj);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Exclude {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Inherited
    public static @interface Include {
    }
}

