/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util;

import java.lang.reflect.Method;
import javax.annotation.Nullable;

public final class CallerFinder {
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    private static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    @Nullable
    private static final Object jla = CallerFinder.getJLA();
    @Nullable
    private static final Method getStackTraceElementMethod = jla == null ? null : CallerFinder.getGetMethod();

    @Nullable
    private static Object getJLA() {
        try {
            Class<?> sharedSecrets = Class.forName(SHARED_SECRETS_CLASSNAME, false, null);
            Method langAccess = sharedSecrets.getMethod("getJavaLangAccess", new Class[0]);
            return langAccess.invoke(null, new Object[0]);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    static Method getGetMethod() {
        try {
            return Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public static StackTraceElement findCaller(Class<?> ... excludedClasses) {
        return CallerFinder.findCaller(new Throwable(), excludedClasses);
    }

    @Nullable
    public static StackTraceElement findCaller(Throwable t, Class<?> ... excludedClasses) {
        StackTraceElement[] stack = getStackTraceElementMethod != null ? null : t.getStackTrace();
        int i = 1;
        while (true) {
            block8: {
                StackTraceElement element;
                if (stack == null) {
                    try {
                        element = (StackTraceElement)getStackTraceElementMethod.invoke(jla, t, i);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    element = stack[i];
                }
                String className = element.getClassName();
                if (!className.equals(CallerFinder.class.getName())) {
                    for (Class<?> excludedClass : excludedClasses) {
                        if (!className.equals(excludedClass.getName())) {
                            continue;
                        }
                        break block8;
                    }
                    return element;
                }
            }
            ++i;
        }
    }

    @Nullable
    public static StackTraceElement findCallerOf(Class<?> ... classesToFind) {
        return CallerFinder.findCallerOf(new Throwable(), classesToFind);
    }

    @Nullable
    public static StackTraceElement findCallerOf(Throwable t, Class<?> ... classesToFind) {
        StackTraceElement[] stack = t.getStackTrace();
        StackTraceElement prevElement = null;
        for (int i = stack.length - 1; i >= 0; --i) {
            StackTraceElement element = stack[i];
            String className = element.getClassName();
            for (Class<?> classToFind : classesToFind) {
                if (!className.equals(classToFind.getName())) continue;
                return prevElement;
            }
            prevElement = element;
        }
        return null;
    }

    private CallerFinder() {
    }
}

