/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.collect.Queues;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AsyncFunction;
import com.google.appengine.repackaged.com.google.common.util.concurrent.CheckedFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ExecutionError;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.appengine.repackaged.com.google.common.util.concurrent.FutureFallback;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SerializingExecutor;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.appengine.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Beta
@GwtCompatible(emulated=true)
public final class Futures {
    private static final AsyncFunction<ListenableFuture<Object>, Object> DEREFERENCER = new AsyncFunction<ListenableFuture<Object>, Object>(){

        @Override
        public ListenableFuture<Object> apply(ListenableFuture<Object> input) {
            return input;
        }
    };
    @GwtIncompatible(value="TODO")
    private static final Ordering<Constructor<?>> WITH_STRING_PARAM_FIRST = Ordering.natural().onResultOf(new Function<Constructor<?>, Boolean>(){

        @Override
        public Boolean apply(Constructor<?> input) {
            return Arrays.asList(input.getParameterTypes()).contains(String.class);
        }
    }).reverse();

    private Futures() {
    }

    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(ListenableFuture<V> future, Function<? super Exception, X> mapper) {
        return new MappingCheckedFuture<V, X>(Preconditions.checkNotNull(future), mapper);
    }

    @GoogleInternal
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> transformExceptions(ListenableFuture<V> input, Function<Throwable, ? extends Throwable> mapper) {
        return new MappingExceptionHandlingFuture<V>(input, mapper);
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        return new ImmediateSuccessfulFuture<V>(value);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V value) {
        return new ImmediateSuccessfulCheckedFuture(value);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFailedFuture(throwable);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        return new ImmediateCancelledFuture();
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(X exception) {
        Preconditions.checkNotNull(exception);
        return new ImmediateFailedCheckedFuture(exception);
    }

    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, FutureFallback<? extends V> fallback) {
        return Futures.withFallback(input, fallback, MoreExecutors.directExecutor());
    }

    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, FutureFallback<? extends V> fallback, Executor executor) {
        Preconditions.checkNotNull(fallback);
        return new FallbackFuture<V>(input, fallback, executor);
    }

    @GwtIncompatible(value="java.util.concurrent.ScheduledExecutorService")
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result = new TimeoutFuture<V>(delegate);
        TimeoutFuture.Fire<V> fire = new TimeoutFuture.Fire<V>(result);
        result.timer = scheduledExecutor.schedule(fire, time, unit);
        delegate.addListener(fire, MoreExecutors.directExecutor());
        return result;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        ChainingListenableFuture output = new ChainingListenableFuture(function, input);
        input.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(executor);
        ChainingListenableFuture output = new ChainingListenableFuture(function, input);
        input.addListener(Futures.rejectionPropagatingRunnable(output, output, executor), MoreExecutors.directExecutor());
        return output;
    }

    private static Runnable rejectionPropagatingRunnable(final AbstractFuture<?> outputFuture, final Runnable delegateTask, final Executor delegateExecutor) {
        return new Runnable(){

            @Override
            public void run() {
                block2: {
                    final AtomicBoolean thrownFromDelegate = new AtomicBoolean(true);
                    try {
                        delegateExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                thrownFromDelegate.set(false);
                                delegateTask.run();
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        if (!thrownFromDelegate.get()) break block2;
                        outputFuture.setException(e);
                    }
                }
            }
        };
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(function);
        ChainingListenableFuture output = new ChainingListenableFuture(Futures.asAsyncFunction(function), input);
        input.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        return Futures.transform(input, Futures.asAsyncFunction(function), executor);
    }

    private static <I, O> AsyncFunction<I, O> asAsyncFunction(final Function<? super I, ? extends O> function) {
        return new AsyncFunction<I, O>(){

            @Override
            public ListenableFuture<O> apply(I input) {
                Object output = function.apply(input);
                return Futures.immediateFuture(output);
            }
        };
    }

    @GwtIncompatible(value="TODO")
    public static <I, O> Future<O> lazyTransform(final Future<I> input, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return input.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return input.isCancelled();
            }

            @Override
            public boolean isDone() {
                return input.isDone();
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(input.get());
            }

            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(input.get(timeout, unit));
            }

            private O applyTransformation(I input2) throws ExecutionException {
                try {
                    return function.apply(input2);
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
        };
    }

    public static <V> ListenableFuture<V> dereference(ListenableFuture<? extends ListenableFuture<? extends V>> nested) {
        return Futures.transform(nested, DEREFERENCER);
    }

    @Beta
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... futures) {
        return Futures.listFuture(ImmutableList.copyOf(futures), true, MoreExecutors.directExecutor());
    }

    @Beta
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return Futures.listFuture(ImmutableList.copyOf(futures), true, MoreExecutors.directExecutor());
    }

    @GoogleInternal
    public static <V> ListenableFuture<V> combine(Callable<V> combiner, Executor executor, ListenableFuture<?> ... futures) {
        return Futures.combine(combiner, executor, ImmutableList.copyOf(futures));
    }

    @GoogleInternal
    public static <V> ListenableFuture<V> combine(Callable<V> combiner, final Executor executor, Iterable<? extends ListenableFuture<?>> futures) {
        Preconditions.checkNotNull(executor);
        ImmutableList<ListenableFuture<?>> futuresList = ImmutableList.copyOf(futures);
        final CombinedFuture<V> outputFuture = new CombinedFuture<V>(combiner, futuresList);
        final AtomicInteger counter = new AtomicInteger(futuresList.size() + 1);
        Runnable listener = new Runnable(){
            volatile boolean thrownByExecute = true;

            @Override
            public void run() {
                block3: {
                    if (counter.decrementAndGet() == 0) {
                        try {
                            executor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    thrownByExecute = false;
                                    outputFuture.run();
                                }
                            });
                        }
                        catch (RejectedExecutionException e) {
                            if (!this.thrownByExecute) break block3;
                            outputFuture.setException(e);
                        }
                    }
                }
            }
        };
        for (ListenableFuture listenableFuture : futuresList) {
            listenableFuture.addListener(listener, MoreExecutors.directExecutor());
        }
        listener.run();
        return outputFuture;
    }

    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> future) {
        return new NonCancellationPropagatingFuture<V>(future);
    }

    @CheckReturnValue
    @Beta
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... futures) {
        return Futures.listFuture(ImmutableList.copyOf(futures), false, MoreExecutors.directExecutor());
    }

    @CheckReturnValue
    @Beta
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return Futures.listFuture(ImmutableList.copyOf(futures), false, MoreExecutors.directExecutor());
    }

    @GoogleInternal
    @GwtIncompatible(value="TODO")
    public static <K, V> ListenableFuture<Map<K, V>> allAsMap(Map<? extends K, ? extends ListenableFuture<? extends V>> futures) {
        return Futures.mapFuture(ImmutableMap.copyOf(futures), true, MoreExecutors.directExecutor());
    }

    @GoogleInternal
    @GwtIncompatible(value="TODO")
    public static <K, V> ListenableFuture<Map<K, V>> successfulAsMap(Map<? extends K, ? extends ListenableFuture<? extends V>> futures) {
        return Futures.mapFuture(ImmutableMap.copyOf(futures), false, MoreExecutors.directExecutor());
    }

    @Beta
    @GwtIncompatible(value="TODO")
    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> futures) {
        final ConcurrentLinkedQueue delegates = Queues.newConcurrentLinkedQueue();
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        SerializingExecutor executor = new SerializingExecutor(MoreExecutors.directExecutor());
        for (final ListenableFuture<T> future : futures) {
            SettableFuture delegate = SettableFuture.create();
            delegates.add(delegate);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    ((SettableFuture)delegates.remove()).setFuture(future);
                }
            }, executor);
            listBuilder.add(delegate);
        }
        return listBuilder.build();
    }

    public static <V> void addCallback(ListenableFuture<V> future, FutureCallback<? super V> callback) {
        Futures.addCallback(future, callback, MoreExecutors.directExecutor());
    }

    public static <V> void addCallback(final ListenableFuture<V> future, final FutureCallback<? super V> callback, Executor executor) {
        Preconditions.checkNotNull(callback);
        Runnable callbackListener = new Runnable(){

            @Override
            public void run() {
                Object value;
                try {
                    value = Uninterruptibles.getUninterruptibly(future);
                }
                catch (ExecutionException e) {
                    callback.onFailure(e.getCause());
                    return;
                }
                catch (RuntimeException e) {
                    callback.onFailure(e);
                    return;
                }
                catch (Error e) {
                    callback.onFailure(e);
                    return;
                }
                callback.onSuccess(value);
            }
        };
        future.addListener(callbackListener, executor);
    }

    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> V get(Future<V> future, Class<X> exceptionClass) throws X {
        Preconditions.checkNotNull(future);
        Preconditions.checkArgument(!RuntimeException.class.isAssignableFrom(exceptionClass), "Futures.get exception type (%s) must not be a RuntimeException", exceptionClass);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Futures.newWithCause(exceptionClass, e);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> V get(Future<V> future, long timeout, TimeUnit unit, Class<X> exceptionClass) throws X {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(unit);
        Preconditions.checkArgument(!RuntimeException.class.isAssignableFrom(exceptionClass), "Futures.get exception type (%s) must not be a RuntimeException", exceptionClass);
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Futures.newWithCause(exceptionClass, e);
        }
        catch (TimeoutException e) {
            throw Futures.newWithCause(exceptionClass, e);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    private static <X extends Exception> void wrapAndThrowExceptionOrError(Throwable cause, Class<X> exceptionClass) throws X {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw Futures.newWithCause(exceptionClass, cause);
    }

    @GwtIncompatible(value="TODO")
    public static <V> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowUnchecked(e.getCause());
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    private static void wrapAndThrowUnchecked(Throwable cause) {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        throw new UncheckedExecutionException(cause);
    }

    @GwtIncompatible(value="TODO")
    private static <X extends Exception> X newWithCause(Class<X> exceptionClass, Throwable cause) {
        List<Constructor<X>> constructors = Arrays.asList(exceptionClass.getConstructors());
        for (Constructor<X> constructor : Futures.preferringStrings(constructors)) {
            Exception instance = (Exception)Futures.newFromConstructor(constructor, cause);
            if (instance == null) continue;
            if (instance.getCause() == null) {
                instance.initCause(cause);
            }
            return (X)instance;
        }
        String string = String.valueOf(exceptionClass);
        throw new IllegalArgumentException(new StringBuilder(82 + String.valueOf(string).length()).append("No appropriate constructor for exception of type ").append(string).append(" in response to chained exception").toString(), cause);
    }

    @GwtIncompatible(value="TODO")
    private static <X extends Exception> List<Constructor<X>> preferringStrings(List<Constructor<X>> constructors) {
        return WITH_STRING_PARAM_FIRST.sortedCopy(constructors);
    }

    @Nullable
    @GwtIncompatible(value="TODO")
    private static <X> X newFromConstructor(Constructor<X> constructor, Throwable cause) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (paramType.equals(String.class)) {
                params[i] = cause.toString();
                continue;
            }
            if (paramType.equals(Throwable.class)) {
                params[i] = cause;
                continue;
            }
            return null;
        }
        try {
            return constructor.newInstance(params);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    @GwtIncompatible(value="TODO")
    private static <V> ListenableFuture<List<V>> listFuture(ImmutableList<ListenableFuture<? extends V>> futures, boolean allMustSucceed, Executor listenerExecutor) {
        return new CollectionFuture(futures, allMustSucceed, listenerExecutor, new FutureCollector<V, List<V>>(){

            @Override
            public List<V> combine(List<Optional<V>> values) {
                ArrayList<Object> result = Lists.newArrayList();
                for (Optional element : values) {
                    result.add(element != null ? (Object)element.orNull() : null);
                }
                return Collections.unmodifiableList(result);
            }
        });
    }

    @GoogleInternal
    @GwtIncompatible(value="TODO")
    private static <K, V> ListenableFuture<Map<K, V>> mapFuture(final ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed, Executor listenerExecutor) {
        return new CollectionFuture(futures.values(), allMustSucceed, listenerExecutor, new FutureCollector<V, Map<K, V>>(){

            @Override
            public Map<K, V> combine(List<Optional<V>> values) {
                LinkedHashMap result = Maps.newLinkedHashMap();
                for (Pair entry : Iterables.pairUp(futures.keySet(), values)) {
                    if (entry.second == null) continue;
                    result.put(entry.first, ((Optional)entry.second).orNull());
                }
                return Collections.unmodifiableMap(result);
            }
        });
    }

    @GoogleInternal
    @GwtIncompatible(value="TODO")
    private static class MappingExceptionHandlingFuture<V>
    extends ForwardingListenableFuture<V> {
        private final ListenableFuture<V> delegate;
        private final Function<Throwable, ? extends Throwable> mapper;

        MappingExceptionHandlingFuture(ListenableFuture<V> delegate, Function<Throwable, ? extends Throwable> mapper) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.mapper = Preconditions.checkNotNull(mapper, "mapper");
        }

        @Override
        protected ListenableFuture<V> delegate() {
            return this.delegate;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            try {
                return this.delegate.get();
            }
            catch (ExecutionException e) {
                throw new ExecutionException(this.mapper.apply(e.getCause()));
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this.delegate.get(timeout, unit);
            }
            catch (ExecutionException e) {
                throw new ExecutionException(this.mapper.apply(e.getCause()));
            }
        }
    }

    @GwtIncompatible(value="TODO")
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<? super Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> delegate, Function<? super Exception, X> mapper) {
            super(delegate);
            this.mapper = Preconditions.checkNotNull(mapper);
        }

        @Override
        protected X mapException(Exception e) {
            return (X)((Exception)this.mapper.apply(e));
        }
    }

    @GwtIncompatible(value="TODO")
    private static final class CollectionFuture<V, C>
    extends AbstractFuture.TrustedFuture<C> {
        private static final Logger logger = Logger.getLogger(CollectionFuture.class.getName());
        private static final AtomicReferenceFieldUpdater<CollectionFuture<?, ?>, Set<Throwable>> SEEN_EXCEPTIONS_UDPATER = AtomicReferenceFieldUpdater.newUpdater(CollectionFuture.class, Set.class, "seenExceptions");
        ImmutableCollection<? extends ListenableFuture<? extends V>> futures;
        final boolean allMustSucceed;
        final AtomicInteger remaining;
        FutureCollector<V, C> combiner;
        List<Optional<V>> values;
        volatile Set<Throwable> seenExceptions;

        CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed, Executor listenerExecutor, FutureCollector<V, C> combiner) {
            this.futures = futures;
            this.allMustSucceed = allMustSucceed;
            this.remaining = new AtomicInteger(futures.size());
            this.combiner = combiner;
            this.values = Lists.newArrayListWithCapacity(futures.size());
            this.seenExceptions = null;
            this.init(listenerExecutor);
        }

        @Override
        void done() {
            this.futures = null;
            this.values = null;
            this.combiner = null;
        }

        protected void init(Executor listenerExecutor) {
            int i;
            if (this.futures.isEmpty()) {
                this.set(this.combiner.combine(ImmutableList.of()));
                return;
            }
            for (i = 0; i < this.futures.size(); ++i) {
                this.values.add(null);
            }
            i = 0;
            for (final ListenableFuture listenableFuture : this.futures) {
                final int index = i++;
                listenableFuture.addListener(new Runnable(){

                    @Override
                    public void run() {
                        CollectionFuture.this.setOneValue(index, listenableFuture);
                    }
                }, listenerExecutor);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ImmutableCollection<ListenableFuture<V>> futuresToCancel = this.futures;
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && futuresToCancel != null) {
                for (ListenableFuture listenableFuture : futuresToCancel) {
                    listenableFuture.cancel(mayInterruptIfRunning);
                }
            }
            return cancelled;
        }

        private void setExceptionAndMaybeLog(Throwable throwable) {
            boolean visibleFromOutputFuture = false;
            boolean firstTimeSeeingThisException = true;
            if (this.allMustSucceed) {
                visibleFromOutputFuture = super.setException(throwable);
                Set<Throwable> seenExceptionsLocal = this.seenExceptions;
                if (seenExceptionsLocal == null) {
                    SEEN_EXCEPTIONS_UDPATER.compareAndSet(this, null, Sets.newConcurrentHashSet());
                    seenExceptionsLocal = this.seenExceptions;
                }
                for (Throwable currentThrowable = throwable; currentThrowable != null && (firstTimeSeeingThisException = seenExceptionsLocal.add(currentThrowable)); currentThrowable = currentThrowable.getCause()) {
                }
            }
            if (throwable instanceof Error || this.allMustSucceed && !visibleFromOutputFuture && firstTimeSeeingThisException) {
                logger.log(Level.SEVERE, "input future failed.", throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void setOneValue(int index, Future<? extends V> future) {
            int newRemaining;
            List<Optional<V>> localValues = this.values;
            if (this.isDone() || localValues == null) {
                Preconditions.checkState(this.allMustSucceed || this.isCancelled(), "Future was done before all dependencies completed");
            }
            try {
                Preconditions.checkState(future.isDone(), "Tried to set value from future which is not done");
                if (future.isCancelled()) {
                    if (this.allMustSucceed) {
                        super.cancel(false);
                    }
                } else {
                    V returnValue = Uninterruptibles.getUninterruptibly(future);
                    if (localValues != null) {
                        localValues.set(index, Optional.fromNullable(returnValue));
                    }
                }
                Preconditions.checkState((newRemaining = this.remaining.decrementAndGet()) >= 0, "Less than 0 remaining futures");
            }
            catch (ExecutionException e) {
                this.setExceptionAndMaybeLog(e.getCause());
                int newRemaining2 = this.remaining.decrementAndGet();
                Preconditions.checkState(newRemaining2 >= 0, "Less than 0 remaining futures");
                if (newRemaining2 == 0) {
                    FutureCollector<V, C> localCombiner = this.combiner;
                    if (localCombiner != null && localValues != null) {
                        this.set(localCombiner.combine(localValues));
                    } else {
                        Preconditions.checkState(this.isDone());
                    }
                    this.seenExceptions = null;
                }
            }
            catch (Throwable t) {
                this.setExceptionAndMaybeLog(t);
                int newRemaining3 = this.remaining.decrementAndGet();
                Preconditions.checkState(newRemaining3 >= 0, "Less than 0 remaining futures");
                {
                    catch (Throwable throwable) {
                        int newRemaining4 = this.remaining.decrementAndGet();
                        Preconditions.checkState(newRemaining4 >= 0, "Less than 0 remaining futures");
                        if (newRemaining4 == 0) {
                            FutureCollector<V, C> localCombiner = this.combiner;
                            if (localCombiner != null && localValues != null) {
                                this.set(localCombiner.combine(localValues));
                            } else {
                                Preconditions.checkState(this.isDone());
                            }
                            this.seenExceptions = null;
                        }
                        throw throwable;
                    }
                }
                if (newRemaining3 == 0) {
                    FutureCollector<V, C> localCombiner = this.combiner;
                    if (localCombiner != null && localValues != null) {
                        this.set(localCombiner.combine(localValues));
                    } else {
                        Preconditions.checkState(this.isDone());
                    }
                    this.seenExceptions = null;
                }
            }
            if (newRemaining == 0) {
                FutureCollector<V, C> localCombiner = this.combiner;
                if (localCombiner != null && localValues != null) {
                    this.set(localCombiner.combine(localValues));
                } else {
                    Preconditions.checkState(this.isDone());
                }
                this.seenExceptions = null;
            }
        }
    }

    @GwtIncompatible(value="TODO")
    private static interface FutureCollector<V, C> {
        public C combine(List<Optional<V>> var1);
    }

    @GwtIncompatible(value="TODO")
    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        NonCancellationPropagatingFuture(final ListenableFuture<V> delegate) {
            delegate.addListener(new Runnable(){

                @Override
                public void run() {
                    NonCancellationPropagatingFuture.this.setFuture(delegate);
                }
            }, MoreExecutors.directExecutor());
        }
    }

    private static final class CombinedFuture<V>
    extends TrustedListenableFutureTask<V> {
        ImmutableList<ListenableFuture<?>> futures;

        CombinedFuture(Callable<V> callable, ImmutableList<ListenableFuture<?>> futures) {
            super(callable);
            this.futures = futures;
        }

        @Override
        void doRun(Callable<V> task) throws Exception {
            try {
                this.set(task.call());
            }
            catch (ExecutionException e) {
                this.setException(e.getCause());
            }
            catch (CancellationException e) {
                this.cancel(false);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ImmutableList<ListenableFuture<?>> localFutures = this.futures;
            if (super.cancel(mayInterruptIfRunning)) {
                if (localFutures != null) {
                    for (ListenableFuture listenableFuture : localFutures) {
                        listenableFuture.cancel(mayInterruptIfRunning);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        void done() {
            this.futures = null;
        }
    }

    private static final class ChainingListenableFuture<I, O>
    extends AbstractFuture.TrustedFuture<O>
    implements Runnable {
        private AsyncFunction<? super I, ? extends O> function;
        private ListenableFuture<? extends I> inputFuture;

        private ChainingListenableFuture(AsyncFunction<? super I, ? extends O> function, ListenableFuture<? extends I> inputFuture) {
            this.function = Preconditions.checkNotNull(function);
            this.inputFuture = Preconditions.checkNotNull(inputFuture);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                ListenableFuture<I> localInputFuture = this.inputFuture;
                if (localInputFuture != null) {
                    localInputFuture.cancel(mayInterruptIfRunning);
                }
                return true;
            }
            return false;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block12: {
                try {
                    I sourceResult;
                    try {
                        sourceResult = Uninterruptibles.getUninterruptibly(this.inputFuture);
                    }
                    catch (CancellationException e) {
                        this.cancel(false);
                        this.function = null;
                        this.inputFuture = null;
                        return;
                    }
                    catch (ExecutionException e) {
                        this.setException(e.getCause());
                        this.function = null;
                        this.inputFuture = null;
                        return;
                    }
                    ListenableFuture<? extends O> outputFuture = this.function.apply(sourceResult);
                    Preconditions.checkNotNull(outputFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
                    this.setFuture(outputFuture);
                    break block12;
                    {
                        catch (UndeclaredThrowableException e) {
                            this.setException(e.getCause());
                            break block12;
                        }
                        catch (Throwable t) {
                            this.setException(t);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.function = null;
                    this.inputFuture = null;
                }
            }
        }
    }

    private static final class TimeoutFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        ListenableFuture<V> delegateRef;
        Future<?> timer;

        TimeoutFuture(ListenableFuture<V> delegate) {
            this.delegateRef = Preconditions.checkNotNull(delegate);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Future<?> localTimer = this.timer;
            ListenableFuture<V> delegate = this.delegateRef;
            if (super.cancel(mayInterruptIfRunning)) {
                if (delegate != null) {
                    this.delegateRef = null;
                    delegate.cancel(mayInterruptIfRunning);
                }
                if (localTimer != null) {
                    this.timer = null;
                    localTimer.cancel(false);
                }
                return true;
            }
            return false;
        }

        private static final class Fire<V>
        implements Runnable {
            TimeoutFuture<V> timeoutFutureRef;

            Fire(TimeoutFuture<V> timeoutFuture) {
                this.timeoutFutureRef = timeoutFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimeoutFuture timeoutFuture = this.timeoutFutureRef;
                if (timeoutFuture == null) {
                    return;
                }
                ListenableFuture delegate = timeoutFuture.delegateRef;
                if (delegate == null) {
                    return;
                }
                this.timeoutFutureRef = null;
                Future<?> timer = timeoutFuture.timer;
                timeoutFuture.delegateRef = null;
                timeoutFuture.timer = null;
                if (delegate.isDone()) {
                    timeoutFuture.setFuture(delegate);
                    if (timer != null) {
                        timer.cancel(false);
                    }
                } else {
                    try {
                        delegate.cancel(true);
                    }
                    finally {
                        String string = String.valueOf(delegate);
                        timeoutFuture.setException(new TimeoutException(new StringBuilder(18 + String.valueOf(string).length()).append("Future timed out: ").append(string).toString()));
                    }
                }
            }
        }
    }

    @GwtIncompatible(value="TODO")
    private static class FallbackFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        ListenableFuture<? extends V> running;

        FallbackFuture(ListenableFuture<? extends V> input, final FutureFallback<? extends V> fallback, Executor executor) {
            this.running = input;
            input.addListener(new Runnable(){

                @Override
                public void run() {
                    Throwable throwable;
                    ListenableFuture localRunning = FallbackFuture.this.running;
                    FallbackFuture.this.running = null;
                    if (localRunning == null | FallbackFuture.this.isCancelled()) {
                        return;
                    }
                    try {
                        FallbackFuture.this.set(Uninterruptibles.getUninterruptibly(localRunning));
                        return;
                    }
                    catch (ExecutionException e) {
                        throwable = e.getCause();
                    }
                    catch (Throwable e) {
                        throwable = e;
                    }
                    try {
                        ListenableFuture replacement = fallback.create(throwable);
                        Preconditions.checkNotNull(replacement, "FutureFallback.create returned null instead of a Future. Did you mean to return immediateFuture(null)?");
                        FallbackFuture.this.setFuture(replacement);
                    }
                    catch (Throwable e) {
                        FallbackFuture.this.setException(e);
                    }
                }
            }, executor);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ListenableFuture<V> current = this.running;
            if (super.cancel(mayInterruptIfRunning)) {
                if (current != null) {
                    current.cancel(mayInterruptIfRunning);
                }
                return true;
            }
            return false;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateFailedCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        private final X thrown;

        ImmediateFailedCheckedFuture(X thrown) {
            this.thrown = thrown;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException((Throwable)this.thrown);
        }

        @Override
        public V checkedGet() throws X {
            throw this.thrown;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) throws X {
            Preconditions.checkNotNull(unit);
            throw this.thrown;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateCancelledFuture<V>
    extends ImmediateFuture<V> {
        private final CancellationException thrown = new CancellationException("Immediate cancelled future.");

        ImmediateCancelledFuture() {
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public V get() {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", this.thrown);
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateFailedFuture<V>
    extends ImmediateFuture<V> {
        private final Throwable thrown;

        ImmediateFailedFuture(Throwable thrown) {
            this.thrown = thrown;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException(this.thrown);
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateSuccessfulCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        @Nullable
        private final V value;

        ImmediateSuccessfulCheckedFuture(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V checkedGet() {
            return this.value;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) {
            Preconditions.checkNotNull(unit);
            return this.value;
        }
    }

    private static class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        @Nullable
        private final V value;

        ImmediateSuccessfulFuture(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }
    }

    private static abstract class ImmediateFuture<V>
    implements ListenableFuture<V> {
        private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

        private ImmediateFuture() {
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            Preconditions.checkNotNull(listener, "Runnable was null.");
            Preconditions.checkNotNull(executor, "Executor was null.");
            try {
                executor.execute(listener);
            }
            catch (RuntimeException e) {
                String string = String.valueOf(listener);
                String string2 = String.valueOf(executor);
                log.log(Level.SEVERE, new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RuntimeException while executing runnable ").append(string).append(" with executor ").append(string2).toString(), e);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public abstract V get() throws ExecutionException;

        @Override
        public V get(long timeout, TimeUnit unit) throws ExecutionException {
            Preconditions.checkNotNull(unit);
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

