/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Stopwatch;
import com.google.appengine.repackaged.com.google.common.base.Ticker;
import com.google.appengine.repackaged.com.google.common.math.DoubleMath;
import com.google.appengine.repackaged.com.google.common.util.concurrent.FixedDelayRateLimiter;
import com.google.appengine.repackaged.com.google.common.util.concurrent.RequestAlignedBucketsRateLimiter;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SecondGranularityHorizonRateLimiter;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SmoothRateLimiter;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Beta
public abstract class RateLimiter {
    private final SleepingStopwatch stopwatch;
    private volatile Object mutexDoNotUseDirectly;

    public static RateLimiter create(double permitsPerSecond) {
        return RateLimiter.create(SleepingStopwatch.createFromSystemTimer(), permitsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public final int latestPermitAgeSec() {
        Object object = this.mutex();
        synchronized (object) {
            return this.doLatestPermitAgeSec(this.stopwatch.readMicros());
        }
    }

    @GoogleInternal
    int doLatestPermitAgeSec(long nowMicros) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public final void setPermitsWithinHorizon(int permitsWithinHorizon) {
        Object object = this.mutex();
        synchronized (object) {
            this.doSetPermitsWithinHorizon(permitsWithinHorizon);
        }
    }

    @GoogleInternal
    void doSetPermitsWithinHorizon(int permitsWithinHorizon) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    static RateLimiter create(SleepingStopwatch stopwatch, double permitsPerSecond) {
        SmoothRateLimiter.SmoothBursty rateLimiter = new SmoothRateLimiter.SmoothBursty(stopwatch, 1.0);
        rateLimiter.setRate(permitsPerSecond);
        return rateLimiter;
    }

    public static RateLimiter create(double permitsPerSecond, long warmupPeriod, TimeUnit unit) {
        Preconditions.checkArgument(warmupPeriod >= 0L, "warmupPeriod must not be negative: %s", warmupPeriod);
        return RateLimiter.create(SleepingStopwatch.createFromSystemTimer(), permitsPerSecond, warmupPeriod, unit, 3.0);
    }

    @GoogleInternal
    public static RateLimiter create(double permitsPerSecond, long warmupPeriod, TimeUnit unit, double coldFactor) {
        Preconditions.checkArgument(warmupPeriod >= 0L, "warmupPeriod must not be negative: %s", warmupPeriod);
        Preconditions.checkArgument(coldFactor >= 1.0, "coldFactor must be >= 1.0: %s", coldFactor);
        return RateLimiter.create(SleepingStopwatch.createFromSystemTimer(), permitsPerSecond, warmupPeriod, unit, coldFactor);
    }

    @VisibleForTesting
    static RateLimiter create(SleepingStopwatch stopwatch, double permitsPerSecond, long warmupPeriod, TimeUnit unit, double coldFactor) {
        SmoothRateLimiter.SmoothWarmingUp rateLimiter = new SmoothRateLimiter.SmoothWarmingUp(stopwatch, warmupPeriod, unit, coldFactor);
        rateLimiter.setRate(permitsPerSecond);
        return rateLimiter;
    }

    @GoogleInternal
    public static RateLimiter createWithCapacity(double permitsPerSecond, long maxBurstBuildup, TimeUnit unit) {
        return RateLimiter.createWithCapacity(SleepingStopwatch.createFromSystemTimer(), permitsPerSecond, maxBurstBuildup, unit);
    }

    @GoogleInternal
    @VisibleForTesting
    static RateLimiter createWithCapacity(SleepingStopwatch stopwatch, double permitsPerSecond, long maxBurstBuildup, TimeUnit unit) {
        Preconditions.checkArgument(maxBurstBuildup >= 0L, "maxBurstBuildup must not be negative: %s", maxBurstBuildup);
        double maxBurstSeconds = (double)unit.toNanos(maxBurstBuildup) / 1.0E9;
        SmoothRateLimiter.SmoothBursty rateLimiter = new SmoothRateLimiter.SmoothBursty(stopwatch, maxBurstSeconds);
        rateLimiter.setRate(permitsPerSecond);
        return rateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object mutex() {
        Object mutex = this.mutexDoNotUseDirectly;
        if (mutex == null) {
            RateLimiter rateLimiter = this;
            synchronized (rateLimiter) {
                mutex = this.mutexDoNotUseDirectly;
                if (mutex == null) {
                    this.mutexDoNotUseDirectly = mutex = new Object();
                }
            }
        }
        return mutex;
    }

    RateLimiter(SleepingStopwatch stopwatch) {
        this.stopwatch = Preconditions.checkNotNull(stopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRate(double permitsPerSecond) {
        Preconditions.checkArgument(permitsPerSecond > 0.0 && !Double.isNaN(permitsPerSecond), "rate must be positive");
        Object object = this.mutex();
        synchronized (object) {
            this.doSetRate(permitsPerSecond, this.stopwatch.readMicros());
        }
    }

    abstract void doSetRate(double var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getRate() {
        Object object = this.mutex();
        synchronized (object) {
            return this.doGetRate();
        }
    }

    abstract double doGetRate();

    public double acquire() {
        return this.acquire(1);
    }

    public double acquire(int permits) {
        long microsToWait = this.reserve(permits);
        this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
        return 1.0 * (double)microsToWait / (double)TimeUnit.SECONDS.toMicros(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long reserve(int permits) {
        RateLimiter.checkPermits(permits);
        Object object = this.mutex();
        synchronized (object) {
            return this.reserveAndGetWaitLength(permits, this.stopwatch.readMicros());
        }
    }

    @GoogleInternal
    final RateLimiter checkSupportsAsync() {
        Preconditions.checkArgument(this.supportsAsync(), "%s does not support asynchronous use", this);
        return this;
    }

    @GoogleInternal
    boolean supportsAsync() {
        return true;
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1, timeout, unit);
    }

    public boolean tryAcquire(int permits) {
        return this.tryAcquire(permits, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        long microsToWait;
        long timeoutMicros = Math.max(unit.toMicros(timeout), 0L);
        RateLimiter.checkPermits(permits);
        Object object = this.mutex();
        synchronized (object) {
            long nowMicros = this.stopwatch.readMicros();
            if (!this.canAcquire(nowMicros, timeoutMicros)) {
                return false;
            }
            microsToWait = this.reserveAndGetWaitLength(permits, nowMicros);
        }
        this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public boolean couldAcquire() {
        Object object = this.mutex();
        synchronized (object) {
            long nowMicros = this.stopwatch.readMicros();
            return this.canAcquire(nowMicros, 0L);
        }
    }

    private boolean canAcquire(long nowMicros, long timeoutMicros) {
        return this.queryEarliestAvailable(nowMicros) - timeoutMicros <= nowMicros;
    }

    final long reserveAndGetWaitLength(int permits, long nowMicros) {
        long momentAvailable = this.reserveEarliestAvailable(permits, nowMicros);
        return Math.max(momentAvailable - nowMicros, 0L);
    }

    abstract long queryEarliestAvailable(long var1);

    abstract long reserveEarliestAvailable(int var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public void forceAcquire() {
        Object object = this.mutex();
        synchronized (object) {
            long nowMicros = this.stopwatch.readMicros();
            this.doForceAcquire(nowMicros);
        }
    }

    @GoogleInternal
    void doForceAcquire(long nowMicros) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format(Locale.ROOT, "RateLimiter[stableRate=%3.1fqps]", this.getRate());
    }

    private static int checkPermits(int permits) {
        Preconditions.checkArgument(permits > 0, "Requested permits (%s) must be positive", permits);
        return permits;
    }

    @GoogleInternal
    public static RateLimiter createWithRequestAlignedBuckets(int permitsPerBucket, int periodInMillis) {
        return RateLimiter.createWithRequestAlignedBuckets(SleepingStopwatch.createFromSystemTimer(), permitsPerBucket, periodInMillis);
    }

    @GoogleInternal
    @VisibleForTesting
    static RateLimiter createWithRequestAlignedBuckets(SleepingStopwatch stopwatch, int permitsPerBucket, int periodInMillis) {
        Preconditions.checkArgument(permitsPerBucket >= 0, "permitsPerBucket (%s) must be nonnegative", permitsPerBucket);
        Preconditions.checkArgument(periodInMillis >= 0, "periodInMillis (%s) must be nonnegative", periodInMillis);
        if (permitsPerBucket == 0) {
            return new FixedDelayRateLimiter(stopwatch, periodInMillis);
        }
        return new RequestAlignedBucketsRateLimiter(stopwatch, permitsPerBucket, periodInMillis);
    }

    @GoogleInternal
    public static RateLimiter createWithSecondGranularityHorizon(int permitsWithinHorizon, int horizonSec) {
        return RateLimiter.createWithSecondGranularityHorizon(permitsWithinHorizon, horizonSec, SleepingStopwatch.createFromSystemTimer());
    }

    @GoogleInternal
    @VisibleForTesting
    public static RateLimiter createWithSecondGranularityHorizon(int permitsWithinHorizon, int horizonSec, Ticker ticker) {
        return RateLimiter.createWithSecondGranularityHorizon(permitsWithinHorizon, horizonSec, RateLimiter.createStopwatch(ticker));
    }

    @GoogleInternal
    @VisibleForTesting
    static RateLimiter createWithSecondGranularityHorizon(int permitsWithinHorizon, int horizonSec, SleepingStopwatch stopwatch) {
        return new SecondGranularityHorizonRateLimiter(stopwatch, permitsWithinHorizon, horizonSec);
    }

    @GoogleInternal
    private static SleepingStopwatch createStopwatch(Ticker ticker) {
        final Stopwatch stopwatch = Stopwatch.createStarted(ticker);
        return new SleepingStopwatch(){

            @Override
            void sleepMicrosUninterruptibly(long micros) {
                Preconditions.checkArgument(micros <= 0L, "request to sleep (%s micros) unexpected for Throttle", micros);
            }

            @Override
            long readMicros() {
                return stopwatch.elapsed(TimeUnit.MICROSECONDS);
            }
        };
    }

    @GoogleInternal
    static int microsToSec(long micros) {
        return (int)TimeUnit.MICROSECONDS.toSeconds(micros);
    }

    @GoogleInternal
    static int roundedPermitsPerTime(double permitsPerSecond, double timeSec) {
        int permitsPerTime = DoubleMath.roundToInt(permitsPerSecond * timeSec, RoundingMode.HALF_UP);
        Preconditions.checkArgument(permitsPerTime > 0, "underflow changing to rate %s over time %s", permitsPerSecond, timeSec);
        return permitsPerTime;
    }

    @VisibleForTesting
    static abstract class SleepingStopwatch {
        SleepingStopwatch() {
        }

        abstract long readMicros();

        abstract void sleepMicrosUninterruptibly(long var1);

        static final SleepingStopwatch createFromSystemTimer() {
            return new SleepingStopwatch(){
                final Stopwatch stopwatch = Stopwatch.createStarted();

                @Override
                long readMicros() {
                    return this.stopwatch.elapsed(TimeUnit.MICROSECONDS);
                }

                @Override
                void sleepMicrosUninterruptibly(long micros) {
                    if (micros > 0L) {
                        Uninterruptibles.sleepUninterruptibly(micros, TimeUnit.MICROSECONDS);
                    }
                }
            };
        }
    }
}

