/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
class TrustedListenableFutureTask<V>
extends AbstractFuture.TrustedFuture<V>
implements RunnableFuture<V> {
    private static final AtomicReferenceFieldUpdater<TrustedListenableFutureTask, Thread> RUNNER = AtomicReferenceFieldUpdater.newUpdater(TrustedListenableFutureTask.class, Thread.class, "runner");
    private Callable<V> task;
    private volatile Thread runner;
    private volatile boolean doneInterrupting;

    static <V> TrustedListenableFutureTask<V> create(Callable<V> callable) {
        return new TrustedListenableFutureTask<V>(callable);
    }

    static <V> TrustedListenableFutureTask<V> create(Runnable runnable, @Nullable V result) {
        return new TrustedListenableFutureTask<V>(Executors.callable(runnable, result));
    }

    TrustedListenableFutureTask(Callable<V> callable) {
        this.task = Preconditions.checkNotNull(callable);
    }

    @Override
    public void run() {
        if (!RUNNER.compareAndSet(this, null, Thread.currentThread())) {
            return;
        }
        try {
            Callable<V> localTask = this.task;
            if (!this.isDone()) {
                this.doRun(localTask);
            }
        }
        catch (Throwable t) {
            this.setException(t);
        }
        finally {
            this.task = null;
            this.runner = null;
            if (this.wasInterrupted()) {
                while (!this.doneInterrupting) {
                    Thread.yield();
                }
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.task = null;
            return true;
        }
        return false;
    }

    @Override
    protected final void interruptTask() {
        Thread currentRunner = this.runner;
        if (currentRunner != null) {
            currentRunner.interrupt();
        }
        this.doneInterrupting = true;
    }

    void doRun(Callable<V> localTask) throws Exception {
        this.set(localTask.call());
    }
}

