/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.io.protocol.ExtensionTags;
import com.google.appengine.repackaged.com.google.io.protocol.Extensions;
import com.google.appengine.repackaged.com.google.io.protocol.LazyParsingExtension;
import com.google.appengine.repackaged.com.google.io.protocol.ProtoString;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.DynamicMutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.Extension;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class ExtendableProtocolMessage<T extends ExtendableProtocolMessage<T>>
extends ProtocolMessage<T> {
    protected ExtensionTags uninterpreted;
    private static final Logger logger = Logger.getLogger(ExtendableProtocolMessage.class.getName());

    public final boolean hasExtension(Extension<T, ?> extension) {
        if (this.uninterpreted == null) {
            return false;
        }
        if (!this.uninterpreted.containsKey(Extensions.getWireTag(extension))) {
            return false;
        }
        if (extension.isRepeated()) {
            List value = (List)this.uninterpreted.get(Extensions.getWireTag(extension)).read(extension);
            return !value.isEmpty();
        }
        return true;
    }

    public final <Ex> Ex getExtension(Extension<T, Ex> extension) {
        if (this.uninterpreted == null) {
            return (Ex)extension.getDefaultValue();
        }
        LazyParsingExtension ext = this.uninterpreted.get(Extensions.getWireTag(extension));
        if (ext == null) {
            return (Ex)extension.getDefaultValue();
        }
        return (Ex)(extension.isRepeated() ? ProtocolSupport.unmodifiableList((List)ext.read(extension)) : ext.read(extension));
    }

    public final <Ex> Ex getMutableExtension(Extension<T, Ex> extension) {
        if (!extension.isRepeated() && extension.getLiteType() != WireFormat.FieldType.MESSAGE) {
            throw new UnsupportedOperationException("getMutableExtension() can only be applied to message or repeated extensions.");
        }
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        return ext.read(extension);
    }

    public final <Ex> Ex getExtension(Extension<T, List<Ex>> extension, int index) {
        return this.getExtension(extension).get(index);
    }

    public final <Ex> int extensionSize(Extension<T, List<Ex>> extension) {
        return this.getExtension(extension).size();
    }

    public final <Ex> T setExtension(Extension<T, Ex> extension, Ex value) {
        this.getUninterpretedForWrite().putExtension(Extensions.getWireTag(extension), LazyParsingExtension.parsed(extension, value));
        return (T)this;
    }

    public final T setExtension(Extension<T, Integer> extension, ProtocolMessageEnum enumValue) {
        return this.setExtension(extension, enumValue.getValue());
    }

    public final T setExtension(Extension<T, ProtoString> extension, String value) {
        return this.setExtension(extension, new ProtoString(value));
    }

    public final T setExtension(Extension<T, ProtoString> extension, byte[] value) {
        return this.setExtension(extension, new ProtoString(value));
    }

    public final <Ex> T setExtension(Extension<T, List<Ex>> extension, int index, Ex value) {
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        ext.read(extension).set(index, value);
        return (T)this;
    }

    public final T setExtension(Extension<T, List<Integer>> extension, int index, ProtocolMessageEnum enumValue) {
        return this.setExtension(extension, index, enumValue.getValue());
    }

    public final T setExtension(Extension<T, List<ProtoString>> extension, int index, String value) {
        return this.setExtension(extension, index, new ProtoString(value));
    }

    public final T setExtension(Extension<T, List<ProtoString>> extension, int index, byte[] value) {
        return this.setExtension(extension, index, new ProtoString(value));
    }

    public final <Ex> T addExtension(Extension<T, List<Ex>> extension, Ex value) {
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        ext.read(extension).add(value);
        return (T)this;
    }

    public final T addExtension(Extension<T, List<Integer>> extension, ProtocolMessageEnum enumValue) {
        return this.addExtension(extension, enumValue.getValue());
    }

    public final T addExtension(Extension<T, List<ProtoString>> extension, String value) {
        return this.addExtension(extension, new ProtoString(value));
    }

    public final T addExtension(Extension<T, List<ProtoString>> extension, byte[] value) {
        return this.addExtension(extension, new ProtoString(value));
    }

    public final <Ex extends MutableMessage> Ex addExtension(Extension<T, List<Ex>> extension) {
        MutableMessage result = ((MutableMessage)extension.getMessageDefaultInstance()).newMessageForType();
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        ext.read(extension).add(result);
        return (Ex)result;
    }

    public final <Ex> T clearExtension(Extension<T, Ex> extension) {
        if (this.uninterpreted != null) {
            this.getUninterpretedForWrite().remove(Extensions.getWireTag(extension));
        }
        return (T)this;
    }

    public final void makeReadAccessThreadSafe(Extension<T, ?> ... extensions) {
        ExtensionTags tags = this.getUninterpretedForWrite();
        for (Extension<T, ?> e : extensions) {
            LazyParsingExtension lpe = tags.get(Extensions.getWireTag(e));
            if (lpe == null) continue;
            lpe.read(e);
        }
    }

    protected abstract ExtensionTags getUninterpretedForWrite();

    private Object convertToProto2Reflection(Descriptors.FieldDescriptor field, Object value) {
        if (field.getType() == Descriptors.FieldDescriptor.Type.STRING) {
            return ((ProtoString)value).get();
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
            return ByteString.copyFrom(((ProtoString)value).getAsBytes());
        }
        return ProtocolType.convertToProto2Reflection(field, value);
    }

    private Object convertFromProto2Reflection(Descriptors.FieldDescriptor field, Object value) {
        if (field.getType() == Descriptors.FieldDescriptor.Type.STRING) {
            return new ProtoString((String)value);
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
            return new ProtoString(((ByteString)value).toByteArray());
        }
        return ProtocolType.convertFromProto2Reflection(field, value);
    }

    @Override
    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        if (this.uninterpreted == null) {
            return super.getAllFields();
        }
        Map<Descriptors.FieldDescriptor, Object> result = super.getAllFieldsMutable();
        for (LazyParsingExtension extension : this.uninterpreted.getAllFields().values()) {
            Descriptors.FieldDescriptor field = extension.getFieldDescriptor();
            if (field == null) continue;
            Object value = extension.read(Extensions.newExtensionForField(field));
            if (field.isRepeated()) {
                if (((List)value).isEmpty()) continue;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object item : (List)value) {
                    list.add(this.convertToProto2Reflection(field, item));
                }
                result.put(field, list);
                continue;
            }
            result.put(field, this.convertToProto2Reflection(field, value));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public boolean hasField(Descriptors.FieldDescriptor field) {
        if (field.isExtension()) {
            if (field.isRepeated()) {
                throw new UnsupportedOperationException("hasField called on a repeated field!");
            }
            Extension extension = Extensions.newExtensionForField(field);
            return this.hasExtension(extension);
        }
        return super.hasField(field);
    }

    @Override
    public Object getField(Descriptors.FieldDescriptor field) {
        if (field.isExtension()) {
            if (field.isRepeated()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < this.getRepeatedFieldCount(field); ++i) {
                    list.add(this.getRepeatedField(field, i));
                }
                return Collections.unmodifiableList(list);
            }
            Extension extension = Extensions.newExtensionForField(field);
            return this.convertToProto2Reflection(field, this.getExtension(extension));
        }
        return super.getField(field);
    }

    @Override
    public T setField(Descriptors.FieldDescriptor field, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.assertMutable();
        if (field.isExtension()) {
            if (field.isRepeated()) {
                this.clearField(field);
                for (Object item : (List)value) {
                    this.addRepeatedField(field, item);
                }
            } else {
                Extension extension = Extensions.newExtensionForField(field);
                this.setExtension(extension, this.convertFromProto2Reflection(field, value));
            }
            return (T)this;
        }
        return (T)((ExtendableProtocolMessage)super.setField(field, value));
    }

    @Override
    public T clearField(Descriptors.FieldDescriptor field) {
        this.assertMutable();
        if (field.isExtension()) {
            Extension extension = Extensions.newExtensionForField(field);
            this.clearExtension(extension);
            return (T)this;
        }
        return (T)((ExtendableProtocolMessage)super.clearField(field));
    }

    @Override
    public int getRepeatedFieldCount(Descriptors.FieldDescriptor field) {
        if (field.isExtension()) {
            if (!field.isRepeated()) {
                throw new UnsupportedOperationException("getRepeatedFieldCount called on a non-repeated field");
            }
            Extension extension = Extensions.newExtensionForField(field);
            if (field.isPacked()) {
                return ProtocolMessage.FieldAccessorTable.convertPackedToList(((ProtoString)this.getExtension(extension)).getAsBytes(), field).size();
            }
            return this.extensionSize(extension);
        }
        return super.getRepeatedFieldCount(field);
    }

    @Override
    public Object getRepeatedField(Descriptors.FieldDescriptor field, int index) {
        if (field.isExtension()) {
            if (!field.isRepeated()) {
                throw new UnsupportedOperationException("getRepeatedField called on a non-repeated field");
            }
            Extension extension = Extensions.newExtensionForField(field);
            if (field.isPacked()) {
                List<Object> list = ProtocolMessage.FieldAccessorTable.convertPackedToList(((ProtoString)this.getExtension(extension)).getAsBytes(), field);
                return list.get(index);
            }
            return this.convertToProto2Reflection(field, this.getExtension(extension, index));
        }
        return super.getRepeatedField(field, index);
    }

    @Override
    public T setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.assertMutable();
        if (field.isExtension()) {
            if (!field.isRepeated()) {
                throw new UnsupportedOperationException("setRepeatedField called on a non-repeated field");
            }
            Extension extension = Extensions.newExtensionForField(field);
            if (field.isPacked()) {
                List<Object> list = ProtocolMessage.FieldAccessorTable.convertPackedToList(((ProtoString)this.getExtension(extension)).getAsBytes(), field);
                list.set(index, value);
                this.setExtension(extension, ProtocolMessage.FieldAccessorTable.convertListToPacked(list, field));
            } else {
                this.setExtension(extension, index, this.convertFromProto2Reflection(field, value));
            }
            return (T)this;
        }
        return (T)((ExtendableProtocolMessage)super.setRepeatedField(field, index, value));
    }

    @Override
    public T addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.assertMutable();
        if (field.isExtension()) {
            if (!field.isRepeated()) {
                throw new UnsupportedOperationException("setRepeatedField called on a non-repeated field");
            }
            Extension extension = Extensions.newExtensionForField(field);
            if (field.isPacked()) {
                List<Object> list = ProtocolMessage.FieldAccessorTable.convertPackedToList(((ProtoString)this.getExtension(extension)).getAsBytes(), field);
                list.add(value);
                this.setExtension(extension, ProtocolMessage.FieldAccessorTable.convertListToPacked(list, field));
            } else {
                this.addExtension(extension, this.convertFromProto2Reflection(field, value));
            }
            return (T)this;
        }
        return (T)((ExtendableProtocolMessage)super.addRepeatedField(field, value));
    }

    @Override
    public Object getMutableField(Descriptors.FieldDescriptor field) {
        this.assertMutable();
        if (field.isExtension()) {
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new UnsupportedOperationException("getMutableField called on a non-message field");
            }
            if (field.isRepeated()) {
                throw new UnsupportedOperationException("getMutableField called on a repeated field");
            }
            Extension extension = Extensions.newExtensionForField(field);
            return this.getMutableExtension(extension);
        }
        return super.getMutableField(field);
    }

    @Override
    public MutableMessage newMessageForField(Descriptors.FieldDescriptor field) {
        if (field.isExtension()) {
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new UnsupportedOperationException("newMessageForField called on a non-message field");
            }
            return DynamicMutableMessage.newMessage(field.getMessageType());
        }
        return super.newMessageForField(field);
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        if (this.uninterpreted == null) {
            return UnknownFieldSet.getDefaultInstance();
        }
        ProtocolSink sink = new ProtocolSink(new byte[this.uninterpreted.encodingSize()]);
        Map<Descriptors.FieldDescriptor, Object> result = super.getAllFieldsMutable();
        for (Map.Entry<Integer, LazyParsingExtension> tagAndData : this.uninterpreted.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = tagAndData.getValue().getFieldDescriptor();
            if (field != null) continue;
            tagAndData.getValue().put(tagAndData.getKey(), sink);
        }
        UnknownFieldSet.Builder builder = UnknownFieldSet.newBuilder();
        try {
            builder.mergeFrom(sink.array(), 0, sink.position());
        }
        catch (InvalidProtocolBufferException e) {
            String string = String.valueOf(e.toString());
            logger.warning(string.length() != 0 ? "Unknown fields are not in valid protobuf wire format: ".concat(string) : new String("Unknown fields are not in valid protobuf wire format: "));
        }
        return builder.build();
    }

    @Override
    public final T setUnknownFields(UnknownFieldSet unknownFields) {
        if (this.uninterpreted != null) {
            ArrayList<Integer> unknownFieldTags = new ArrayList<Integer>();
            for (Map.Entry<Integer, LazyParsingExtension> tagAndData : this.uninterpreted.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor field = tagAndData.getValue().getFieldDescriptor();
                if (field != null) continue;
                unknownFieldTags.add(tagAndData.getKey());
            }
            for (Integer wireTag : unknownFieldTags) {
                this.uninterpreted.remove(wireTag);
            }
        } else {
            this.uninterpreted = new ExtensionTags();
        }
        ProtocolSource source = new ProtocolSource(unknownFields.toByteArray());
        while (source.remaining() > 0) {
            int wireTag = source.getVarInt();
            byte[] data = source.getUninterpreted(wireTag);
            this.uninterpreted.putBytes(wireTag, data);
        }
        return (T)this;
    }
}

