/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Extension;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.InternalProtobufMeta;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MutableGeneratedMetadataProto;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class GeneratedExtensionRegistry
extends ExtensionRegistry {
    private final Map<NameIntPair, LazyExtensionInfo> immutableExtensionsByNumber;
    private final Map<NameIntPair, LazyExtensionInfo> mutableExtensionsByNumber;
    private final Map<String, LazyExtensionInfo> immutableExtensionsByName = new HashMap<String, LazyExtensionInfo>();
    private final Map<String, LazyExtensionInfo> mutableExtensionsByName = new HashMap<String, LazyExtensionInfo>();

    @Override
    public ExtensionRegistry getUnmodifiable() {
        return this;
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findExtensionByName(String fullName) {
        return this.findImmutableExtensionByName(fullName);
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findImmutableExtensionByName(String fullName) {
        LazyExtensionInfo info = this.immutableExtensionsByName.get(fullName);
        return info == null ? null : info.getExtensionInfo();
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findMutableExtensionByName(String fullName) {
        LazyExtensionInfo info = this.mutableExtensionsByName.get(fullName);
        return info == null ? null : info.getExtensionInfo();
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findExtensionByNumber(Descriptors.Descriptor containingType, int fieldNumber) {
        return this.findImmutableExtensionByNumber(containingType, fieldNumber);
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findImmutableExtensionByNumber(Descriptors.Descriptor containingType, int fieldNumber) {
        LazyExtensionInfo info = this.immutableExtensionsByNumber.get(new NameIntPair(containingType.getFullName(), fieldNumber));
        if (info != null) {
            ExtensionRegistry.ExtensionInfo result = info.getExtensionInfo();
            if (result.descriptor.getContainingType() == containingType) {
                return result;
            }
        }
        return null;
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findMutableExtensionByNumber(Descriptors.Descriptor containingType, int fieldNumber) {
        LazyExtensionInfo info = this.mutableExtensionsByNumber.get(new NameIntPair(containingType.getFullName(), fieldNumber));
        if (info != null) {
            ExtensionRegistry.ExtensionInfo result = info.getExtensionInfo();
            if (result.descriptor.getContainingType() == containingType) {
                return result;
            }
        }
        return null;
    }

    @Override
    public Set<ExtensionRegistry.ExtensionInfo> getAllImmutableExtensionsByExtendedType(String name) {
        HashSet<ExtensionRegistry.ExtensionInfo> extensions = new HashSet<ExtensionRegistry.ExtensionInfo>();
        for (NameIntPair pair : this.immutableExtensionsByNumber.keySet()) {
            if (!pair.name.equals(name)) continue;
            extensions.add(this.immutableExtensionsByNumber.get(pair).getExtensionInfo());
        }
        return extensions;
    }

    @Override
    public Set<ExtensionRegistry.ExtensionInfo> getAllMutableExtensionsByExtendedType(String name) {
        HashSet<ExtensionRegistry.ExtensionInfo> extensions = new HashSet<ExtensionRegistry.ExtensionInfo>();
        for (NameIntPair pair : this.mutableExtensionsByNumber.keySet()) {
            if (!pair.name.equals(name)) continue;
            extensions.add(this.mutableExtensionsByNumber.get(pair).getExtensionInfo());
        }
        return extensions;
    }

    @Override
    public void add(Extension<?, ?> extension) {
        throw GeneratedExtensionRegistry.newUnsupported();
    }

    @Override
    public void add(Descriptors.FieldDescriptor type) {
        throw GeneratedExtensionRegistry.newUnsupported();
    }

    @Override
    public void add(Descriptors.FieldDescriptor type, Message defaultInstance) {
        throw GeneratedExtensionRegistry.newUnsupported();
    }

    @Override
    public <ContainingType extends MessageLite> GeneratedMessageLite.GeneratedExtension<ContainingType, ?> findLiteExtensionByNumber(ContainingType containingTypeDefaultInstance, int fieldNumber) {
        throw new UnsupportedOperationException("GeneratedExtensionRegistry does not work for Lite extensions.");
    }

    private static UnsupportedOperationException newUnsupported() {
        return new UnsupportedOperationException("GeneratedExtensionRegistry cannot be modified");
    }

    GeneratedExtensionRegistry() {
        super(true);
        this.immutableExtensionsByNumber = new HashMap<NameIntPair, LazyExtensionInfo>();
        this.mutableExtensionsByNumber = new HashMap<NameIntPair, LazyExtensionInfo>();
    }

    GeneratedExtensionRegistry loadMetadata() {
        InternalProtobufMeta protobufMeta = InternalProtobufMeta.getInstance();
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry extension : protobufMeta.getExtensions()) {
            this.add(extension);
        }
        return this;
    }

    private void add(MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry entry) {
        Map<NameIntPair, LazyExtensionInfo> extensionsByNumber;
        Map<String, LazyExtensionInfo> extensionsByName;
        NameIntPair numberKey = new NameIntPair(entry.getExtendedType(), entry.getNumber());
        LazyExtensionInfo info = new LazyExtensionInfo(entry.getLoadPathAsBytes());
        if (entry.getImmutable()) {
            extensionsByName = this.immutableExtensionsByName;
            extensionsByNumber = this.immutableExtensionsByNumber;
        } else {
            extensionsByName = this.mutableExtensionsByName;
            extensionsByNumber = this.mutableExtensionsByNumber;
        }
        String name = entry.getName();
        extensionsByName.put(name, info);
        if (entry.getUseScopeAsAltName()) {
            extensionsByName.put(name.substring(0, name.lastIndexOf(46)), info);
        }
        extensionsByNumber.put(numberKey, info);
    }

    private static final class LazyExtensionInfo {
        private byte[] loadPath;
        private volatile ExtensionRegistry.ExtensionInfo info = null;

        public LazyExtensionInfo(byte[] loadPath) {
            this.loadPath = loadPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExtensionRegistry.ExtensionInfo getExtensionInfo() {
            if (this.info == null) {
                LazyExtensionInfo lazyExtensionInfo = this;
                synchronized (lazyExtensionInfo) {
                    if (this.info == null) {
                        this.loadExtensionInfo();
                    }
                }
            }
            return this.info;
        }

        private void loadExtensionInfo() {
            String stringLoadPath = new String(this.loadPath, Charset.forName("UTF8"));
            int index = stringLoadPath.indexOf(58);
            if (index > 0) {
                String scope = stringLoadPath.substring(0, index);
                String name = stringLoadPath.substring(index + 1, stringLoadPath.length());
                try {
                    Class<?> clazz = Class.forName(scope);
                    Field field = clazz.getDeclaredField(name);
                    Extension extension = (Extension)field.get(null);
                    this.info = ExtensionRegistry.newExtensionInfo(extension);
                    this.loadPath = null;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Failed to load the class that defines the extension.", e);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException("Failed to find the GeneratedExtension Field.", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Failed to access the GeneratedExtension.", e);
                }
            } else {
                String string = String.valueOf(stringLoadPath);
                throw new IllegalStateException(string.length() != 0 ? "Failed to load the GeneratedExtension due to illegal load path: ".concat(string) : new String("Failed to load the GeneratedExtension due to illegal load path: "));
            }
        }
    }

    private static final class NameIntPair {
        private final String name;
        private final int number;

        NameIntPair(String name, int number) {
            this.name = name;
            this.number = number;
        }

        public int hashCode() {
            return this.name.hashCode() * 65535 + this.number;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NameIntPair)) {
                return false;
            }
            NameIntPair other = (NameIntPair)obj;
            return this.name.equals(other.name) && this.number == other.number;
        }
    }
}

