/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MessageLiteOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class MessageUtils {
    private static final String GET_DEFAULT_INSTANCE_MSG = "Message class must implement the #getDefaultInstance() static method: ";

    public static <T extends MessageLite> T getDefaultInstance(Class<T> type) {
        try {
            return (T)((MessageLite)type.cast(type.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0])));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String string = String.valueOf(GET_DEFAULT_INSTANCE_MSG);
            String string2 = String.valueOf(type);
            throw new IllegalArgumentException(new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString(), e);
        }
    }

    public static String getProtoTypeName(Class<? extends MessageLite> clazz) {
        MessageLite proto = MessageUtils.getDefaultInstance(clazz);
        if (proto instanceof GeneratedMessage) {
            return ((GeneratedMessage)proto).getDescriptorForType().getFullName();
        }
        ProtocolMessage proto1 = (ProtocolMessage)proto;
        return proto1.getProtocolType().getProtocolDescriptor().getProtoName();
    }

    public static <T extends Enum<T>> String getProto2EnumTypeName(Class<T> enumClass) {
        try {
            Method m = enumClass.getMethod("getDescriptor", new Class[0]);
            Descriptors.EnumDescriptor desc = (Descriptors.EnumDescriptor)m.invoke(null, new Object[0]);
            return desc.getFullName();
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Bad reflection stuff shouldn't have happened:");
        }
    }

    public static <T extends Enum<T>> String getProto1EnumTypeName(Class<T> enumClass) {
        String enumClassName = enumClass.getSimpleName();
        try {
            String parentTypeName = MessageUtils.getProtoTypeName(enumClass.getEnclosingClass());
            return new StringBuilder(1 + String.valueOf(parentTypeName).length() + String.valueOf(enumClassName).length()).append(parentTypeName).append(".").append(enumClassName).toString();
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Bad reflection stuff shouldn't have happened:");
        }
    }

    public static Message toMessage(MessageOrBuilder messageOrBuilder) {
        return (Message)MessageUtils.toMessageLite(messageOrBuilder);
    }

    public static MessageLite toMessageLite(MessageLiteOrBuilder messageOrBuilder) {
        Preconditions.checkNotNull(messageOrBuilder);
        if (messageOrBuilder instanceof MessageLite) {
            return (MessageLite)messageOrBuilder;
        }
        if (messageOrBuilder instanceof MessageLite.Builder) {
            MessageLite.Builder builder = (MessageLite.Builder)messageOrBuilder;
            return builder.build();
        }
        throw new IllegalStateException("MessageLiteOrBuilder must be a MessageLite or a MessageLite.Builder!");
    }

    public static Message.Builder toBuilder(MessageOrBuilder messageOrBuilder) {
        return (Message.Builder)MessageUtils.toBuilderLite(messageOrBuilder);
    }

    public static MessageLite.Builder toBuilderLite(MessageLiteOrBuilder messageLiteOrBuilder) {
        Preconditions.checkNotNull(messageLiteOrBuilder);
        if (messageLiteOrBuilder instanceof MessageLite.Builder) {
            return (MessageLite.Builder)messageLiteOrBuilder;
        }
        if (messageLiteOrBuilder instanceof MessageLite) {
            MessageLite messageLite = (MessageLite)messageLiteOrBuilder;
            return messageLite.toBuilder();
        }
        throw new IllegalStateException("MessageLiteOrBuilder must be a MessageLite or a MessageLite.Builder!");
    }

    public static Object getValue(MessageOrBuilder message, Descriptors.FieldDescriptor ... fields) {
        return MessageUtils.getValue(message, Iterators.forArray(fields));
    }

    public static <T> T getValue(MessageOrBuilder message, Iterator<Descriptors.FieldDescriptor> fields) {
        try {
            Object currentValue = message;
            while (fields.hasNext()) {
                Descriptors.FieldDescriptor fieldDescriptor;
                String fieldClassName;
                Object msg = currentValue;
                String msgClassName = msg.getDescriptorForType().getFullName();
                if (!msgClassName.equals(fieldClassName = (fieldDescriptor = fields.next()).getContainingType().getFullName())) {
                    throw new IllegalStateException(String.format("Expected message class %s, but was %s", fieldClassName, msgClassName));
                }
                if (!fieldDescriptor.isRepeated() ? !msg.hasField(fieldDescriptor) && !fields.hasNext() : msg.getRepeatedFieldCount(fieldDescriptor) == 0 && !fields.hasNext()) {
                    return (T)fieldDescriptor.getDefaultValue();
                }
                currentValue = msg.getField(fieldDescriptor);
            }
            return (T)currentValue;
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("Each field in the path (except the last) must correspond to a message", cce);
        }
    }

    public static <B extends Message.Builder> B compress(B builder) {
        for (Descriptors.FieldDescriptor field : builder.getDescriptorForType().getFields()) {
            Message.Builder subBuilder;
            if (field.isRepeated()) {
                if (!field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) continue;
                for (int i = 0; i < builder.getRepeatedFieldCount(field); ++i) {
                    subBuilder = builder.newBuilderForField(field);
                    subBuilder.mergeFrom((Message)builder.getRepeatedField(field, i));
                    MessageUtils.compress(subBuilder);
                    builder.setRepeatedField(field, i, subBuilder.build());
                }
                continue;
            }
            if (field.isRequired()) {
                if (!field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) continue;
                Message.Builder subBuilder2 = builder.newBuilderForField(field);
                subBuilder2.mergeFrom((Message)builder.getField(field));
                MessageUtils.compress(subBuilder2);
                builder.setField(field, subBuilder2.build());
                continue;
            }
            if (!builder.hasField(field)) continue;
            if (field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                Message.Builder emptyBuilder = builder.newBuilderForField(field);
                subBuilder = emptyBuilder.clone();
                subBuilder.mergeFrom((Message)builder.getField(field));
                Message subMessage = MessageUtils.compress(subBuilder).build();
                if (subMessage.equals(emptyBuilder.buildPartial())) {
                    builder.clearField(field);
                    continue;
                }
                builder.setField(field, subMessage);
                continue;
            }
            Object currentValue = builder.getField(field);
            if (!Objects.equals(currentValue, field.getDefaultValue())) continue;
            builder.clearField(field);
        }
        return builder;
    }

    public static <T extends Message.Builder> T setAllOptionalFields(T builder) {
        return MessageUtils.setFields(builder, FieldsType.OPTIONAL_ONLY);
    }

    public static <T extends Message.Builder> T setAllRequiredFields(T builder) {
        return MessageUtils.setFields(builder, FieldsType.REQUIRED_ONLY);
    }

    public static <T extends Message.Builder> T setAllFields(T builder) {
        return MessageUtils.setFields(builder, FieldsType.REQUIRED_AND_OPTIONAL);
    }

    private static <T extends Message.Builder> T setFields(T builder, FieldsType type) {
        for (Descriptors.FieldDescriptor descriptor : builder.getDescriptorForType().getFields()) {
            Object example;
            if (!(type == FieldsType.OPTIONAL_ONLY && !descriptor.isRequired() || type == FieldsType.REQUIRED_ONLY && descriptor.isRequired()) && type != FieldsType.REQUIRED_AND_OPTIONAL) continue;
            boolean bl = descriptor.isRepeated() ? builder.getRepeatedFieldCount(descriptor) == 0 : !builder.hasField(descriptor);
            boolean generateField = bl;
            if (!generateField) continue;
            if (!descriptor.isRepeated() && descriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                example = descriptor.getDefaultValue();
            } else {
                switch (descriptor.getJavaType()) {
                    case MESSAGE: {
                        example = MessageUtils.setFields(builder.newBuilderForField(descriptor), type).buildPartial();
                        break;
                    }
                    case ENUM: {
                        example = descriptor.getEnumType().getValues().get(0);
                        break;
                    }
                    case BOOLEAN: {
                        example = Boolean.FALSE;
                        break;
                    }
                    case BYTE_STRING: {
                        example = ByteString.EMPTY;
                        break;
                    }
                    case DOUBLE: {
                        example = 0.0;
                        break;
                    }
                    case FLOAT: {
                        example = Float.valueOf(0.0f);
                        break;
                    }
                    case INT: {
                        example = 0;
                        break;
                    }
                    case LONG: {
                        example = 0L;
                        break;
                    }
                    case STRING: {
                        example = "";
                        break;
                    }
                    default: {
                        String string = String.valueOf(descriptor);
                        throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Cannot handle type ").append(string).toString());
                    }
                }
            }
            if (descriptor.isRepeated()) {
                builder.addRepeatedField(descriptor, example);
                continue;
            }
            builder.setField(descriptor, example);
        }
        return builder;
    }

    public static boolean clearOptionalFields(Message.Builder builder) {
        boolean messageEmpty = true;
        Map<Descriptors.FieldDescriptor, Object> fields = builder.getAllFields();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            boolean clearField = false;
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value = entry.getValue();
            switch (field.getJavaType()) {
                case ENUM: 
                case BOOLEAN: 
                case BYTE_STRING: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case STRING: {
                    if (!field.isOptional() || !value.equals(field.getDefaultValue())) break;
                    clearField = true;
                    break;
                }
                case MESSAGE: {
                    Message.Builder subBuilder;
                    if (field.isRepeated()) {
                        int size = builder.getRepeatedFieldCount(field);
                        for (int i = 0; i < size; ++i) {
                            Message.Builder subBuilder2 = ((Message)builder.getRepeatedField(field, i)).toBuilder();
                            MessageUtils.clearOptionalFields(subBuilder2);
                            builder.setRepeatedField(field, i, subBuilder2.build());
                        }
                        break;
                    }
                    try {
                        subBuilder = builder.getFieldBuilder(field);
                    }
                    catch (UnsupportedOperationException e) {
                        subBuilder = builder.newBuilderForField(field).mergeFrom((Message)value);
                    }
                    clearField = MessageUtils.clearOptionalFields(subBuilder);
                }
            }
            if (clearField) {
                builder.clearField(field);
                continue;
            }
            messageEmpty = false;
        }
        return messageEmpty;
    }

    public static boolean containsUnknownFields(MessageOrBuilder message) {
        if (!message.getUnknownFields().equals(UnknownFieldSet.getDefaultInstance())) {
            return true;
        }
        for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = field.getKey();
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            Object fieldValue = field.getValue();
            ImmutableList<MessageOrBuilder> subMessages = fieldDescriptor.isRepeated() ? (ImmutableList<MessageOrBuilder>)fieldValue : ImmutableList.of((MessageOrBuilder)fieldValue);
            for (MessageOrBuilder subMessage : subMessages) {
                if (!MessageUtils.containsUnknownFields(subMessage)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends Enum<T>> T getEnumValue(Descriptors.EnumValueDescriptor valueDescriptor, Class<T> enumType) {
        try {
            Method valueOf = enumType.getMethod("valueOf", Descriptors.EnumValueDescriptor.class);
            return (T)((Enum)enumType.cast(valueOf.invoke(null, valueDescriptor)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw new AssertionError(String.format("ProtocolEnum class %s must implement valueOf(int) static method.", enumType), e);
        }
    }

    private MessageUtils() {
    }

    private static enum FieldsType {
        REQUIRED_ONLY,
        OPTIONAL_ONLY,
        REQUIRED_AND_OPTIONAL;

    }
}

