/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor_pool;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.InternalProtobufMeta;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableGeneratedMetadataProto;
import com.google.appengine.repackaged.com.google.protobuf.contrib.MessageUtils;
import com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor_pool.DescriptorPool;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class GeneratedDescriptorPool {
    @GuardedBy(value="descriptorPool")
    private final DescriptorPool descriptorPool;
    private final ImmutableMap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> generatedMessageMap;

    private GeneratedDescriptorPool(ImmutableMap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> generatedMessageMap) {
        this.generatedMessageMap = generatedMessageMap;
        this.descriptorPool = new DescriptorPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Descriptors.Descriptor getDescriptorForTypeName(String typeName) {
        Descriptors.Descriptor descriptor;
        DescriptorPool descriptorPool = this.descriptorPool;
        synchronized (descriptorPool) {
            descriptor = this.descriptorPool.getDescriptorForTypeName(typeName);
        }
        if (descriptor == null) {
            this.populateDescriptorPoolForTypeName(typeName);
            descriptorPool = this.descriptorPool;
            synchronized (descriptorPool) {
                descriptor = this.descriptorPool.getDescriptorForTypeName(typeName);
            }
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDescriptorPoolForTypeName(String typeName) {
        MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry messageEntry = this.generatedMessageMap.get(typeName);
        if (messageEntry == null) {
            return;
        }
        String clazzName = messageEntry.getLoadPath();
        Message defaultInstance = this.getDefaultInstance(clazzName);
        DescriptorPool descriptorPool = this.descriptorPool;
        synchronized (descriptorPool) {
            this.descriptorPool.populateFromMessageType(defaultInstance);
        }
    }

    private Message getDefaultInstance(String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            return (Message)MessageUtils.getDefaultInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            String string = String.valueOf(clazzName);
            throw new IllegalStateException(string.length() != 0 ? "Failed to load the class for the message at the load path: ".concat(string) : new String("Failed to load the class for the message at the load path: "), e);
        }
    }

    public static GeneratedDescriptorPool newInstance() {
        return new GeneratedDescriptorPool(GeneratedDescriptorPool.loadMetadata());
    }

    private static ImmutableMap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> loadMetadata() {
        ImmutableMap.Builder<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> generatedMessageMapBuilder = ImmutableMap.builder();
        List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> entries = InternalProtobufMeta.getInstance().getMessages();
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry entry : entries) {
            if (!entry.getImmutable()) continue;
            generatedMessageMapBuilder.put(entry.getName(), entry);
        }
        return generatedMessageMapBuilder.build();
    }
}

