/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.commands;

import com.google.cloud.sql.tool.AbstractCommand;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.CommandException;
import com.google.cloud.sql.tool.Context;
import com.google.cloud.sql.tool.Sql;
import com.google.cloud.sql.tool.SqlConsole;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class SourceCommand
extends AbstractCommand {
    private final Sql.SqlChildCreator sqlChildCreator;

    public SourceCommand(Sql.SqlChildCreator sqlChildCreator) {
        super("source", '@', "Executes the argument as a sql script.");
        this.sqlChildCreator = sqlChildCreator;
    }

    @Override
    public Command.Result execute(List<String> args, Context context) throws CommandException {
        if (args.isEmpty()) {
            String string = String.valueOf(this.getHelpText());
            throw new CommandException(this, string.length() != 0 ? "Usage: ".concat(string) : new String("Usage: "));
        }
        try {
            File file = new File(args.get(0));
            if (!file.isFile()) {
                throw new CommandException(this, String.valueOf(file.getPath()).concat(" does not exist."));
            }
            if (!file.canRead()) {
                String string = String.valueOf(file.getPath());
                throw new CommandException(this, string.length() != 0 ? "Unable to read file: ".concat(string) : new String("Unable to read file: "));
            }
            Sql child = this.sqlChildCreator.create(SqlConsole.create(new FileReader(file)));
            if (child.run() != 0) {
                String string = String.valueOf(file.getPath());
                throw new CommandException(this, string.length() != 0 ? "Unknown error executing file: ".concat(string) : new String("Unknown error executing file: "));
            }
        }
        catch (IOException e) {
            throw new CommandException(this, e.getMessage(), e);
        }
        return Command.Result.OK;
    }
}

