/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.commands;

import com.google.cloud.sql.tool.AbstractCommand;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.CommandException;
import com.google.cloud.sql.tool.Context;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;

public class TeeCommand
extends AbstractCommand {
    public TeeCommand() {
        super("tee", 'T', "Tee output to [file]. Write everything to file in addition to stdout.");
    }

    @Override
    public Command.Result execute(List<String> args, Context context) throws CommandException {
        String fileName = null;
        if (!args.isEmpty()) {
            if (args.size() > 1) {
                String string = String.valueOf(this.getHelpText());
                throw new CommandException(this, string.length() != 0 ? "Usage: ".concat(string) : new String("Usage: "));
            }
            fileName = args.get(0);
        } else {
            fileName = context.getFileOutputName();
            if (fileName == null) {
                context.getWriter().println("No previous file name, please give a file name.");
                context.setNullFileWriter();
                return Command.Result.OK;
            }
        }
        try {
            context.setFileOutputName(fileName);
            context.getWriter().println(MessageFormat.format("Logging to file ''{0}''", fileName));
        }
        catch (IOException e) {
            String string = String.valueOf(fileName);
            throw new CommandException(this, string.length() != 0 ? "Unable to open file ".concat(string) : new String("Unable to open file "), e);
        }
        return Command.Result.OK;
    }
}

