/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.googleapi;

import com.google.cloud.sql.Driver;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.tool.Sql;
import com.google.cloud.sql.tool.googleapi.OAuth2ConnectionFactory;
import com.google.cloud.sql.tool.googleapi.Version;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SqlTool {
    private static String CONNECTION_FACTORY = OAuth2ConnectionFactory.class.getName();
    private static String DRIVER = Driver.class.getName();

    public static void main(String[] originalArgs) {
        List<String> nonFlagArgs = SqlTool.nonFlagArgs(originalArgs);
        List<String> flagArgs = SqlTool.flagArgs(originalArgs);
        boolean verbose = flagArgs.contains("--verbose");
        if (flagArgs.contains("--help") || flagArgs.contains("--version")) {
            SqlTool.showHelpAndExit();
        } else if (nonFlagArgs.isEmpty()) {
            SqlTool.showHelpAndExit();
        }
        ArrayList<String> args = Util.newArrayList();
        String string = String.valueOf(DRIVER);
        args.add(string.length() != 0 ? "--driver=".concat(string) : new String("--driver="));
        String string2 = String.valueOf(SqlTool.makeUrl(nonFlagArgs));
        args.add(string2.length() != 0 ? "--url=".concat(string2) : new String("--url="));
        String string3 = String.valueOf(CONNECTION_FACTORY);
        args.add(string3.length() != 0 ? "--connection_factory=".concat(string3) : new String("--connection_factory="));
        args.add("--server=https://www.googleapis.com/sql/v1/");
        args.addAll(SqlTool.flagArgs(originalArgs));
        if (verbose) {
            String string4 = String.valueOf(((Object)args).toString());
            System.err.println(string4.length() != 0 ? "args = ".concat(string4) : new String("args = "));
        }
        Sql.main(args.toArray(new String[args.size()]));
    }

    private static List<String> nonFlagArgs(String[] args) {
        ArrayList<String> result = Util.newArrayList();
        for (String arg : args) {
            if (arg.startsWith("--")) continue;
            result.add(arg);
        }
        return result;
    }

    private static List<String> flagArgs(String[] args) {
        ArrayList<String> result = Util.newArrayList();
        for (String arg : args) {
            if (!arg.startsWith("--")) continue;
            result.add(arg);
        }
        return result;
    }

    private static String makeUrl(List<String> args) {
        Iterator<String> iter = args.iterator();
        StringBuilder url = new StringBuilder("jdbc:google:rdbms://").append(iter.next());
        if (iter.hasNext()) {
            url.append('/').append(iter.next());
        }
        return url.toString();
    }

    public static void showHelpAndExit() {
        String string = String.valueOf(Version.getVersion());
        System.out.println(string.length() != 0 ? "Google SQL Service tool. Release ".concat(string) : new String("Google SQL Service tool. Release "));
        System.out.println("Usage: \n");
        System.out.println("\t<sql_googleapi> <instance> [database]");
        System.exit(0);
    }
}

