/**********************************************************************
Copyright (c) 2007 Thomas Marti and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import java.awt.Rectangle;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;

/**
 * Mapping for java.awt.Rectangle, maps the x, y, width and height values to int-precision 
 * datastore fields
 */
public class RectangleMapping extends SingleFieldMultiMapping
{

    private static final Rectangle sampleValue = new Rectangle(0, 0, 1, 1);

	/* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#initialize()
     */
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr)
    {
		super.initialize(dba, fmd, container, clr);

        addDatastoreField(ClassNameConstants.INT); // X
        addDatastoreField(ClassNameConstants.INT); // Y
        addDatastoreField(ClassNameConstants.INT); // Width
        addDatastoreField(ClassNameConstants.INT); // Height
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getJavaType()
     */
    public Class getJavaType()
    {
        return Rectangle.class;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getSampleValue()
     */
    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return sampleValue;
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#setObject(org.datanucleus.ObjectManager, java.lang.Object, int[], java.lang.Object)
     */
    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value)
    {
    	Rectangle rectangle = (Rectangle)value;
        if (rectangle == null)
        {
    		for (int i = 0; i < exprIndex.length; i++) 
    		{
    			getDataStoreMapping(i).setObject(preparedStatement, exprIndex[i], null);					
			}
        }
        else
        {
            getDataStoreMapping(0).setInt(preparedStatement,exprIndex[0],rectangle.x);
            getDataStoreMapping(1).setInt(preparedStatement,exprIndex[1],rectangle.y);
            getDataStoreMapping(2).setInt(preparedStatement,exprIndex[2],rectangle.width);
            getDataStoreMapping(3).setInt(preparedStatement,exprIndex[3],rectangle.height);
        }
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getObject(org.datanucleus.ObjectManager, java.lang.Object, int[])
     */
    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex)
    {
        // Check for null entries
        if (getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null)
        {
            return null;
        }

        int x = getDataStoreMapping(0).getInt(resultSet,exprIndex[0]); 
        int y = getDataStoreMapping(1).getInt(resultSet,exprIndex[1]); 
        int width  = getDataStoreMapping(2).getInt(resultSet,exprIndex[2]); 
        int height = getDataStoreMapping(3).getInt(resultSet,exprIndex[3]);
        return new Rectangle(x, y, width, height);
    }
}