/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ValidUrlRule
extends Rule {
    private static final Logger LOG = Log.getLogger(ValidUrlRule.class);
    String _code = "400";
    String _reason = "Illegal Url";

    public ValidUrlRule() {
        this._handling = true;
        this._terminating = true;
    }

    public void setCode(String code) {
        this._code = code;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int codepoint;
        String uri = URIUtil.decodePath((String)request.getRequestURI());
        for (int i = 0; i < uri.length(); i += Character.charCount(codepoint)) {
            codepoint = uri.codePointAt(i);
            if (this.isValidChar(uri.codePointAt(i))) continue;
            int code = Integer.parseInt(this._code);
            if (code >= 400) {
                response.sendError(code, this._reason);
            } else {
                response.setStatus(code);
            }
            return target;
        }
        return null;
    }

    protected boolean isValidChar(int codepoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codepoint);
        LOG.debug("{} {} {} {}", new Object[]{Character.charCount(codepoint), codepoint, block, Character.isISOControl(codepoint)});
        return !Character.isISOControl(codepoint) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public String toString() {
        return super.toString() + "[" + this._code + ":" + this._reason + "]";
    }
}

