/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.WebSocket;

public class TyrusRemoteEndpoint
extends SPIRemoteEndpoint {
    private final WebSocket socket;
    private static final ConcurrentHashMap<WebSocket, TyrusRemoteEndpoint> sockets = new ConcurrentHashMap();

    public TyrusRemoteEndpoint(WebSocket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TyrusRemoteEndpoint get(WebSocket socket) {
        ConcurrentHashMap<WebSocket, TyrusRemoteEndpoint> concurrentHashMap = sockets;
        synchronized (concurrentHashMap) {
            TyrusRemoteEndpoint s = sockets.get(socket);
            if (s == null) {
                s = new TyrusRemoteEndpoint(socket);
                sockets.put(socket, s);
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(WebSocket socket) {
        ConcurrentHashMap<WebSocket, TyrusRemoteEndpoint> concurrentHashMap = sockets;
        synchronized (concurrentHashMap) {
            sockets.remove(socket);
        }
    }

    public Future<DataFrame> sendText(String text) throws IOException {
        return this.socket.send(text);
    }

    public Future<DataFrame> sendBinary(ByteBuffer byteBuffer) throws IOException {
        return this.socket.send(byteBuffer.array());
    }

    public Future<DataFrame> sendText(String fragment, boolean isLast) throws IOException {
        return this.socket.stream(isLast, fragment);
    }

    public Future<DataFrame> sendBinary(ByteBuffer byteBuffer, boolean b) throws IOException {
        byte[] bytes = byteBuffer.array();
        return this.socket.stream(b, bytes, 0, bytes.length);
    }

    public Future<DataFrame> sendPing(ByteBuffer byteBuffer) {
        return this.socket.sendPing(byteBuffer.array());
    }

    public Future<DataFrame> sendPong(ByteBuffer byteBuffer) {
        return this.socket.sendPong(byteBuffer.array());
    }

    public void close(CloseReason closeReason) {
        this.socket.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    public void setWriteTimeout(long timeoutMs) {
        this.socket.setWriteTimeout(timeoutMs);
    }
}

