/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;

class ReflectProperties {
    ReflectProperties() {
    }

    @NotNull
    public static <T> LazyVal<T> lazy(@NotNull Function0<T> initializer) {
        return new LazyVal<T>(initializer);
    }

    @NotNull
    public static <T> LazySoftVal<T> lazySoft(@NotNull Function0<T> initializer) {
        return new LazySoftVal<T>(initializer);
    }

    @NotNull
    public static <T> LazyWeakVal<T> lazyWeak(@NotNull Function0<T> initializer) {
        return new LazyWeakVal<T>(initializer);
    }

    public static class LazyWeakVal<T>
    extends Val<T> {
        private final Function0<T> initializer;
        private WeakReference<Object> value = null;

        public LazyWeakVal(@NotNull Function0<T> initializer) {
            this.initializer = initializer;
        }

        @Override
        public T get(Object instance, Object metadata) {
            Object result;
            WeakReference<Object> cached = this.value;
            if (cached != null && (result = cached.get()) != null) {
                return this.unescape(result);
            }
            result = this.initializer.invoke();
            this.value = new WeakReference<Object>(this.escape(result));
            return result;
        }
    }

    public static class LazySoftVal<T>
    extends Val<T> {
        private final Function0<T> initializer;
        private SoftReference<Object> value = null;

        public LazySoftVal(@NotNull Function0<T> initializer) {
            this.initializer = initializer;
        }

        @Override
        public T get(Object instance, Object metadata) {
            Object result;
            SoftReference<Object> cached = this.value;
            if (cached != null && (result = cached.get()) != null) {
                return this.unescape(result);
            }
            result = this.initializer.invoke();
            this.value = new SoftReference<Object>(this.escape(result));
            return (T)result;
        }
    }

    public static class LazyVal<T>
    extends Val<T> {
        private final Function0<T> initializer;
        private Object value = null;

        public LazyVal(@NotNull Function0<T> initializer) {
            this.initializer = initializer;
        }

        @Override
        public T get(Object instance, Object metadata) {
            Object cached = this.value;
            if (cached != null) {
                return this.unescape(cached);
            }
            Object result = this.initializer.invoke();
            this.value = this.escape(result);
            return (T)result;
        }
    }

    public static abstract class Val<T> {
        private static final Object NULL_VALUE = new Object(){};

        public abstract T get(Object var1, Object var2);

        protected Object escape(T value) {
            return value == null ? NULL_VALUE : value;
        }

        protected T unescape(Object value) {
            return (T)(value == NULL_VALUE ? null : value);
        }
    }
}

