/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinClass;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorImpl;

public class ClassDescriptorImpl
extends ClassDescriptorBase {
    private final Modality modality;
    private final TypeConstructor typeConstructor;
    private final JetScope staticScope = new StaticScopeForKotlinClass(this);
    private JetScope scopeForMemberLookup;
    private Set<ConstructorDescriptor> constructors;
    private ConstructorDescriptor primaryConstructor;

    public ClassDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull Modality modality, @NotNull Collection<JetType> supertypes2, @NotNull SourceElement source) {
        super(LockBasedStorageManager.NO_LOCKS, containingDeclaration, name, source);
        this.modality = modality;
        this.typeConstructor = TypeConstructorImpl.createForClass(this, Annotations.EMPTY, false, this.getName().asString(), Collections.emptyList(), supertypes2);
    }

    public final void initialize(@NotNull JetScope scopeForMemberLookup, @NotNull Set<ConstructorDescriptor> constructors2, @Nullable ConstructorDescriptor primaryConstructor2) {
        this.scopeForMemberLookup = scopeForMemberLookup;
        this.constructors = constructors2;
        this.primaryConstructor = primaryConstructor2;
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor primaryConstructor2) {
        this.primaryConstructor = primaryConstructor2;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.EMPTY;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        return this.constructors;
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberLookup() {
        return this.scopeForMemberLookup;
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    @Nullable
    public ClassDescriptor getCompanionObjectDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return ClassKind.CLASS;
    }

    @Override
    public boolean isCompanionObject() {
        return false;
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.PUBLIC;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    public String toString() {
        return "class " + this.getName();
    }
}

