/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.JetType;

public class PropertyGetterDescriptorImpl
extends PropertyAccessorDescriptorImpl
implements PropertyGetterDescriptor {
    private JetType returnType;
    @NotNull
    private final PropertyGetterDescriptor original;

    public PropertyGetterDescriptorImpl(@NotNull PropertyDescriptor correspondingProperty, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean hasBody, boolean isDefault, @NotNull CallableMemberDescriptor.Kind kind, @Nullable PropertyGetterDescriptor original, @NotNull SourceElement source) {
        super(modality, visibility, correspondingProperty, annotations2, Name.special("<get-" + correspondingProperty.getName() + ">"), hasBody, isDefault, kind, source);
        this.original = original != null ? original : this;
    }

    public void initialize(JetType returnType) {
        this.returnType = returnType == null ? this.getCorrespondingProperty().getType() : returnType;
    }

    @NotNull
    public Set<? extends PropertyAccessorDescriptor> getOverriddenDescriptors() {
        return super.getOverriddenDescriptors(true);
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        return Collections.emptyList();
    }

    @Override
    public JetType getReturnType() {
        return this.returnType;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitPropertyGetterDescriptor(this, data2);
    }

    @Override
    @NotNull
    public PropertyGetterDescriptor getOriginal() {
        return this.original;
    }
}

